/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.WrappedRunnable;

public abstract class AbstractCompactionTask
extends WrappedRunnable {
    protected final ColumnFamilyStore cfs;
    protected LifecycleTransaction transaction;
    protected boolean isUserDefined;
    protected OperationType compactionType;

    public AbstractCompactionTask(ColumnFamilyStore cfs, LifecycleTransaction transaction) {
        this.cfs = cfs;
        this.transaction = transaction;
        this.isUserDefined = false;
        this.compactionType = OperationType.COMPACTION;
        Set<SSTableReader> compacting = transaction.tracker.getCompacting();
        for (SSTableReader sstable : transaction.originals()) {
            assert (compacting.contains(sstable)) : sstable.getFilename() + " is not correctly marked compacting";
        }
    }

    public int execute(CompactionManager.CompactionExecutorStatsCollector collector) {
        try {
            int n = this.executeInternal(collector);
            return n;
        }
        finally {
            this.transaction.close();
        }
    }

    public abstract CompactionAwareWriter getCompactionAwareWriter(ColumnFamilyStore var1, Directories var2, LifecycleTransaction var3, Set<SSTableReader> var4);

    protected abstract int executeInternal(CompactionManager.CompactionExecutorStatsCollector var1);

    public AbstractCompactionTask setUserDefined(boolean isUserDefined) {
        this.isUserDefined = isUserDefined;
        return this;
    }

    public AbstractCompactionTask setCompactionType(OperationType compactionType) {
        this.compactionType = compactionType;
        return this;
    }

    public String toString() {
        return "CompactionTask(" + this.transaction + ")";
    }
}

