/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.rows.AbstractCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class BufferCell
extends AbstractCell {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new BufferCell(ColumnDefinition.regularDef("", "", "", ByteType.instance), 0L, 0, 0, ByteBufferUtil.EMPTY_BYTE_BUFFER, null));
    private final long timestamp;
    private final int ttl;
    private final int localDeletionTime;
    private final ByteBuffer value;
    private final CellPath path;

    public BufferCell(ColumnDefinition column, long timestamp, int ttl, int localDeletionTime, ByteBuffer value, CellPath path) {
        super(column);
        assert (column.isComplex() == (path != null));
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.localDeletionTime = localDeletionTime;
        this.value = value;
        this.path = path;
    }

    public static BufferCell live(ColumnDefinition column, long timestamp, ByteBuffer value) {
        return BufferCell.live(column, timestamp, value, null);
    }

    public static BufferCell live(ColumnDefinition column, long timestamp, ByteBuffer value, CellPath path) {
        return new BufferCell(column, timestamp, 0, Integer.MAX_VALUE, value, path);
    }

    public static BufferCell expiring(ColumnDefinition column, long timestamp, int ttl, int nowInSec, ByteBuffer value) {
        return BufferCell.expiring(column, timestamp, ttl, nowInSec, value, null);
    }

    public static BufferCell expiring(ColumnDefinition column, long timestamp, int ttl, int nowInSec, ByteBuffer value, CellPath path) {
        assert (ttl != 0);
        return new BufferCell(column, timestamp, ttl, nowInSec + ttl, value, path);
    }

    public static BufferCell tombstone(ColumnDefinition column, long timestamp, int nowInSec) {
        return BufferCell.tombstone(column, timestamp, nowInSec, null);
    }

    public static BufferCell tombstone(ColumnDefinition column, long timestamp, int nowInSec, CellPath path) {
        return new BufferCell(column, timestamp, 0, nowInSec, ByteBufferUtil.EMPTY_BYTE_BUFFER, path);
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public int ttl() {
        return this.ttl;
    }

    @Override
    public int localDeletionTime() {
        return this.localDeletionTime;
    }

    @Override
    public ByteBuffer value() {
        return this.value;
    }

    @Override
    public CellPath path() {
        return this.path;
    }

    @Override
    public Cell withUpdatedColumn(ColumnDefinition newColumn) {
        return new BufferCell(newColumn, this.timestamp, this.ttl, this.localDeletionTime, this.value, this.path);
    }

    @Override
    public Cell withUpdatedValue(ByteBuffer newValue) {
        return new BufferCell(this.column, this.timestamp, this.ttl, this.localDeletionTime, newValue, this.path);
    }

    @Override
    public Cell copy(AbstractAllocator allocator) {
        if (!this.value.hasRemaining()) {
            return this;
        }
        return new BufferCell(this.column, this.timestamp, this.ttl, this.localDeletionTime, allocator.clone(this.value), this.path == null ? null : this.path.copy(allocator));
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.value) + (this.path == null ? 0L : this.path.unsharedHeapSizeExcludingData());
    }
}

