/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.conf;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sasi.SSTableIndex;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.conf.view.View;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTracker {
    private static final Logger logger = LoggerFactory.getLogger(DataTracker.class);
    private final AbstractType<?> keyValidator;
    private final ColumnIndex columnIndex;
    private final AtomicReference<View> view = new AtomicReference();

    public DataTracker(AbstractType<?> keyValidator, ColumnIndex index) {
        this.keyValidator = keyValidator;
        this.columnIndex = index;
        this.view.set(new View(index, Collections.emptySet()));
    }

    public View getView() {
        return this.view.get();
    }

    public Iterable<SSTableReader> update(Collection<SSTableReader> oldSSTables, Collection<SSTableReader> newSSTables) {
        View newView;
        View currentView;
        Set<SSTableIndex> newIndexes = this.getIndexes(newSSTables);
        Set<SSTableReader> indexedSSTables = this.getSSTables(newIndexes);
        while (!this.view.compareAndSet(currentView = this.view.get(), newView = new View(this.columnIndex, currentView.getIndexes(), oldSSTables, newIndexes))) {
        }
        return newSSTables.stream().filter(sstable -> !indexedSSTables.contains(sstable)).collect(Collectors.toList());
    }

    public boolean hasSSTable(SSTableReader sstable) {
        View currentView = this.view.get();
        for (SSTableIndex index : currentView) {
            if (!index.getSSTable().equals(sstable)) continue;
            return true;
        }
        return false;
    }

    public void dropData(long truncateUntil) {
        View currentView = this.view.get();
        if (currentView == null) {
            return;
        }
        HashSet<SSTableReader> toRemove = new HashSet<SSTableReader>();
        for (SSTableIndex index : currentView) {
            SSTableReader sstable = index.getSSTable();
            if (sstable.getMaxTimestamp() > truncateUntil) continue;
            index.markObsolete();
            toRemove.add(sstable);
        }
        this.update(toRemove, Collections.emptyList());
    }

    private Set<SSTableIndex> getIndexes(Collection<SSTableReader> sstables) {
        HashSet<SSTableIndex> indexes = new HashSet<SSTableIndex>(sstables.size());
        for (SSTableReader sstable : sstables) {
            File indexFile;
            if (sstable.isMarkedCompacted() || !(indexFile = new File(sstable.descriptor.filenameFor(this.columnIndex.getComponent()))).exists()) continue;
            SSTableIndex index = null;
            try {
                index = new SSTableIndex(this.columnIndex, indexFile, sstable);
                logger.info("SSTableIndex.open(column: {}, minTerm: {}, maxTerm: {}, minKey: {}, maxKey: {}, sstable: {})", new Object[]{this.columnIndex.getColumnName(), this.columnIndex.getValidator().getString(index.minTerm()), this.columnIndex.getValidator().getString(index.maxTerm()), this.keyValidator.getString(index.minKey()), this.keyValidator.getString(index.maxKey()), index.getSSTable()});
                if (indexes.add(index)) continue;
                index.release();
            }
            catch (Throwable t) {
                logger.error("Can't open index file at " + indexFile.getAbsolutePath() + ", skipping.", t);
                if (index == null) continue;
                index.release();
            }
        }
        return indexes;
    }

    private Set<SSTableReader> getSSTables(Set<SSTableIndex> indexes) {
        return Sets.newHashSet((Iterable)indexes.stream().map(SSTableIndex::getSSTable).collect(Collectors.toList()));
    }
}

