/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.plan;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.index.sasi.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.plan.Expression;
import org.apache.cassandra.index.sasi.plan.QueryController;
import org.apache.cassandra.index.sasi.utils.RangeIntersectionIterator;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.index.sasi.utils.RangeUnionIterator;
import org.apache.cassandra.utils.FBUtilities;

public class Operation
extends RangeIterator<Long, Token> {
    private final QueryController controller;
    protected final OperationType op;
    protected final ListMultimap<ColumnDefinition, Expression> expressions;
    protected final RangeIterator<Long, Token> range;
    protected Operation left;
    protected Operation right;

    private Operation(OperationType operation, QueryController controller, ListMultimap<ColumnDefinition, Expression> expressions, RangeIterator<Long, Token> range, Operation left, Operation right) {
        super(range);
        this.op = operation;
        this.controller = controller;
        this.expressions = expressions;
        this.range = range;
        this.left = left;
        this.right = right;
    }

    public boolean satisfiedBy(Unfiltered currentCluster, Row staticRow, boolean allowMissingColumns) {
        boolean sideR;
        boolean sideL;
        if (this.expressions == null || this.expressions.isEmpty()) {
            sideL = this.left != null && this.left.satisfiedBy(currentCluster, staticRow, allowMissingColumns);
            boolean bl = sideR = this.right != null && this.right.satisfiedBy(currentCluster, staticRow, allowMissingColumns);
            if (this.left == null) {
                return sideR;
            }
        } else {
            sideL = this.localSatisfiedBy(currentCluster, staticRow, allowMissingColumns);
            if (this.right == null) {
                return sideL;
            }
            sideR = this.right.satisfiedBy(currentCluster, staticRow, allowMissingColumns);
        }
        return this.op.apply(sideL, sideR);
    }

    private boolean localSatisfiedBy(Unfiltered currentCluster, Row staticRow, boolean allowMissingColumns) {
        if (currentCluster == null || !currentCluster.isRow()) {
            return false;
        }
        int now = FBUtilities.nowInSeconds();
        boolean result = false;
        int idx = 0;
        for (ColumnDefinition column : this.expressions.keySet()) {
            boolean isMissingColumn;
            if (column.kind == ColumnDefinition.Kind.PARTITION_KEY) continue;
            ByteBuffer value = ColumnIndex.getValueOf(column, column.kind == ColumnDefinition.Kind.STATIC ? staticRow : (Row)currentCluster, now);
            boolean bl = isMissingColumn = value == null;
            if (!allowMissingColumns && isMissingColumn) {
                throw new IllegalStateException("All indexed columns should be included into the column slice, missing: " + column);
            }
            boolean isMatch = false;
            List filters = this.expressions.get((Object)column);
            for (int i = filters.size() - 1; i >= 0; --i) {
                Expression expression = (Expression)filters.get(i);
                boolean bl2 = isMatch = !isMissingColumn && expression.isSatisfiedBy(value);
                if (expression.getOp() == Expression.Op.NOT_EQ) {
                    boolean bl3 = isMatch = !isMatch;
                    if (isMatch) continue;
                    break;
                }
                if (isMatch || isMissingColumn) break;
            }
            if (idx++ == 0) {
                result = isMatch;
                continue;
            }
            result = this.op.apply(result, isMatch);
            if (this.op != OperationType.AND || result) continue;
            return false;
        }
        return idx == 0 || result;
    }

    @VisibleForTesting
    protected static ListMultimap<ColumnDefinition, Expression> analyzeGroup(QueryController controller, OperationType op, List<RowFilter.Expression> expressions) {
        ArrayListMultimap analyzed = ArrayListMultimap.create();
        Collections.sort(expressions, (a, b) -> {
            int cmp = a.column().compareTo(b.column());
            return cmp == 0 ? -Integer.compare(Operation.getPriority(a.operator()), Operation.getPriority(b.operator())) : cmp;
        });
        for (RowFilter.Expression e : expressions) {
            Expression range;
            ColumnIndex columnIndex = controller.getIndex(e);
            List perColumn = analyzed.get((Object)e.column());
            if (columnIndex == null) {
                columnIndex = new ColumnIndex(controller.getKeyValidator(), e.column(), null);
            }
            AbstractAnalyzer analyzer = columnIndex.getAnalyzer();
            analyzer.reset(e.getIndexValue());
            boolean isMultiExpression = false;
            switch (e.operator()) {
                case EQ: {
                    isMultiExpression = false;
                    break;
                }
                case LIKE_PREFIX: 
                case LIKE_SUFFIX: 
                case LIKE_CONTAINS: 
                case LIKE_MATCHES: {
                    isMultiExpression = true;
                    break;
                }
                case NEQ: {
                    boolean bl = isMultiExpression = perColumn.size() == 0 || perColumn.size() > 1 || perColumn.size() == 1 && ((Expression)perColumn.get(0)).getOp() == Expression.Op.NOT_EQ;
                }
            }
            if (isMultiExpression) {
                while (analyzer.hasNext()) {
                    ByteBuffer token = analyzer.next();
                    perColumn.add(new Expression(controller, columnIndex).add(e.operator(), token));
                }
                continue;
            }
            if (perColumn.size() == 0 || op != OperationType.AND) {
                range = new Expression(controller, columnIndex);
                perColumn.add(range);
            } else {
                range = (Expression)Iterables.getLast((Iterable)perColumn);
            }
            while (analyzer.hasNext()) {
                range.add(e.operator(), analyzer.next());
            }
        }
        return analyzed;
    }

    private static int getPriority(Operator op) {
        switch (op) {
            case EQ: {
                return 5;
            }
            case LIKE_PREFIX: 
            case LIKE_SUFFIX: 
            case LIKE_CONTAINS: 
            case LIKE_MATCHES: {
                return 4;
            }
            case GTE: 
            case GT: {
                return 3;
            }
            case LTE: 
            case LT: {
                return 2;
            }
            case NEQ: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected Token computeNext() {
        return this.range != null && this.range.hasNext() ? (Token)this.range.next() : (Token)this.endOfData();
    }

    @Override
    protected void performSkipTo(Long nextToken) {
        if (this.range != null) {
            this.range.skipTo(nextToken);
        }
    }

    @Override
    public void close() throws IOException {
        this.controller.releaseIndexes(this);
    }

    public static class Builder {
        private final QueryController controller;
        protected final OperationType op;
        protected final List<RowFilter.Expression> expressions;
        protected Builder left;
        protected Builder right;

        public Builder(OperationType operation, QueryController controller, RowFilter.Expression ... columns) {
            this.op = operation;
            this.controller = controller;
            this.expressions = new ArrayList<RowFilter.Expression>();
            Collections.addAll(this.expressions, columns);
        }

        public Builder setRight(Builder operation) {
            this.right = operation;
            return this;
        }

        public Builder setLeft(Builder operation) {
            this.left = operation;
            return this;
        }

        public void add(RowFilter.Expression e) {
            this.expressions.add(e);
        }

        public void add(Collection<RowFilter.Expression> newExpressions) {
            if (this.expressions != null) {
                this.expressions.addAll(newExpressions);
            }
        }

        public Operation complete() {
            RangeIterator join;
            if (!this.expressions.isEmpty()) {
                ListMultimap<ColumnDefinition, Expression> analyzedExpressions = Operation.analyzeGroup(this.controller, this.op, this.expressions);
                RangeIterator.Builder<Long, Token> range = this.controller.getIndexes(this.op, analyzedExpressions.values());
                Operation rightOp = null;
                if (this.right != null) {
                    rightOp = this.right.complete();
                    range.add(rightOp);
                }
                return new Operation(this.op, this.controller, analyzedExpressions, range.build(), null, rightOp);
            }
            Operation leftOp = null;
            Operation rightOp = null;
            boolean leftIndexes = false;
            boolean rightIndexes = false;
            if (this.left != null) {
                leftOp = this.left.complete();
                boolean bl = leftIndexes = leftOp != null && leftOp.range != null;
            }
            if (this.right != null) {
                rightOp = this.right.complete();
                boolean bl = rightIndexes = rightOp != null && rightOp.range != null;
            }
            if (leftIndexes && !rightIndexes) {
                join = leftOp;
            } else if (!leftIndexes && rightIndexes) {
                join = rightOp;
            } else if (leftIndexes) {
                RangeIterator.Builder builder = this.op == OperationType.OR ? RangeUnionIterator.builder() : RangeIntersectionIterator.builder();
                join = builder.add(leftOp).add(rightOp).build();
            } else {
                throw new AssertionError((Object)"both sub-trees have 0 indexes.");
            }
            return new Operation(this.op, this.controller, null, join, leftOp, rightOp);
        }
    }

    public static enum OperationType {
        AND,
        OR;


        public boolean apply(boolean a, boolean b) {
            switch (this) {
                case OR: {
                    return a | b;
                }
                case AND: {
                    return a & b;
                }
            }
            throw new AssertionError();
        }
    }
}

