/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.crypto.batch.CryptoBatchTranslatorFactoryDecorator;
import org.apache.cayenne.crypto.cipher.CipherFactory;
import org.apache.cayenne.crypto.cipher.DefaultCipherFactory;
import org.apache.cayenne.crypto.key.JceksKeySource;
import org.apache.cayenne.crypto.key.KeySource;
import org.apache.cayenne.crypto.map.ColumnMapper;
import org.apache.cayenne.crypto.map.PatternColumnMapper;
import org.apache.cayenne.crypto.reader.CryptoRowReaderFactoryDecorator;
import org.apache.cayenne.crypto.transformer.DefaultTransformerFactory;
import org.apache.cayenne.crypto.transformer.TransformerFactory;
import org.apache.cayenne.crypto.transformer.bytes.BytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.bytes.DefaultBytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.value.DefaultValueTransformerFactory;
import org.apache.cayenne.crypto.transformer.value.ValueTransformerFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Module;

public class CryptoModuleBuilder {
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_MODE = "CBC";
    private static final String DEFAULT_CIPHER_PADDING = "PKCS5Padding";
    private Class<? extends ValueTransformerFactory> valueTransformerFactoryType = DefaultValueTransformerFactory.class;
    private Class<? extends BytesTransformerFactory> bytesTransformerFactoryType = DefaultBytesTransformerFactory.class;
    private String columnMapperPattern = "^CRYPTO_";
    private ColumnMapper columnMapper;
    private Class<? extends ColumnMapper> columnMapperType;
    private String cipherAlgoritm = "AES";
    private String cipherMode = "CBC";
    private String cipherPadding = "PKCS5Padding";
    private Class<? extends CipherFactory> cipherFactoryType = DefaultCipherFactory.class;
    private URL keyStoreUrl;
    private String keyStoreUrlString;
    private File keyStoreFile;
    private Class<? extends KeySource> keySourceType = JceksKeySource.class;
    private KeySource keySource;
    private String encryptionKeyAlias;
    private char[] keyPassword;
    private boolean compress;

    public CryptoModuleBuilder cipherAlgorithm(String algorithm) {
        this.cipherAlgoritm = algorithm;
        return this;
    }

    public CryptoModuleBuilder cipherMode(String mode) {
        this.cipherMode = mode;
        return this;
    }

    public CryptoModuleBuilder cipherFactory(Class<? extends CipherFactory> factoryType) {
        this.cipherFactoryType = factoryType;
        return this;
    }

    public CryptoModuleBuilder valueTransformer(Class<? extends ValueTransformerFactory> factoryType) {
        this.valueTransformerFactoryType = factoryType;
        return this;
    }

    public CryptoModuleBuilder bytesTransformer(Class<? extends BytesTransformerFactory> factoryType) {
        this.bytesTransformerFactoryType = factoryType;
        return this;
    }

    public CryptoModuleBuilder columnMapper(Class<? extends ColumnMapper> columnMapperType) {
        this.columnMapperPattern = null;
        this.columnMapperType = columnMapperType;
        this.columnMapper = null;
        return this;
    }

    public CryptoModuleBuilder columnMapper(ColumnMapper columnMapper) {
        this.columnMapperPattern = null;
        this.columnMapperType = null;
        this.columnMapper = columnMapper;
        return this;
    }

    public CryptoModuleBuilder columnMapper(String pattern) {
        this.columnMapperPattern = pattern;
        this.columnMapperType = null;
        this.columnMapper = null;
        return this;
    }

    public CryptoModuleBuilder encryptionKeyAlias(String encryptionKeyAlias) {
        this.encryptionKeyAlias = encryptionKeyAlias;
        return this;
    }

    public CryptoModuleBuilder keyStore(File file, char[] passwordForAllKeys, String encryptionKeyAlias) {
        this.encryptionKeyAlias = encryptionKeyAlias;
        this.keyPassword = passwordForAllKeys;
        this.keyStoreUrl = null;
        this.keyStoreUrlString = null;
        this.keyStoreFile = file;
        return this;
    }

    public CryptoModuleBuilder keyStore(String url, char[] passwordForAllKeys, String encryptionKeyAlias) {
        this.encryptionKeyAlias = encryptionKeyAlias;
        this.keyPassword = passwordForAllKeys;
        this.keyStoreUrl = null;
        this.keyStoreUrlString = url;
        this.keyStoreFile = null;
        return this;
    }

    public CryptoModuleBuilder keyStore(URL url, char[] passwordForAllKeys, String encryptionKeyAlias) {
        this.encryptionKeyAlias = encryptionKeyAlias;
        this.keyPassword = passwordForAllKeys;
        this.keyStoreUrl = url;
        this.keyStoreUrlString = null;
        this.keyStoreFile = null;
        return this;
    }

    public CryptoModuleBuilder keySource(Class<? extends KeySource> type) {
        this.keySourceType = type;
        this.keySource = null;
        return this;
    }

    public CryptoModuleBuilder keySource(KeySource keySource) {
        this.keySourceType = null;
        this.keySource = keySource;
        return this;
    }

    public CryptoModuleBuilder compress() {
        this.compress = true;
        return this;
    }

    public Module build() {
        if (this.valueTransformerFactoryType == null) {
            throw new IllegalStateException("'ValueTransformerFactory' is not initialized");
        }
        if (this.columnMapperType == null && this.columnMapper == null && this.columnMapperPattern == null) {
            throw new IllegalStateException("'ColumnMapper' is not initialized");
        }
        if (this.cipherFactoryType == null) {
            throw new IllegalStateException("'CipherFactory' is not initialized");
        }
        return new Module(){

            public void configure(Binder binder) {
                String keyStoreUrl = null;
                if (CryptoModuleBuilder.this.keyStoreUrl != null) {
                    keyStoreUrl = CryptoModuleBuilder.this.keyStoreUrl.toExternalForm();
                } else if (CryptoModuleBuilder.this.keyStoreUrlString != null) {
                    keyStoreUrl = CryptoModuleBuilder.this.keyStoreUrlString;
                } else if (CryptoModuleBuilder.this.keyStoreFile != null) {
                    try {
                        keyStoreUrl = CryptoModuleBuilder.this.keyStoreFile.toURI().toURL().toExternalForm();
                    }
                    catch (MalformedURLException e) {
                        throw new IllegalStateException("Invalid keyStore file", e);
                    }
                }
                MapBuilder props = binder.bindMap("cayenne.crypto.properties").put("cayenne.crypto.cipher.algorithm", (Object)CryptoModuleBuilder.this.cipherAlgoritm).put("cayenne.crypto.cipher.mode", (Object)CryptoModuleBuilder.this.cipherMode).put("cayenne.crypto.cipher.padding", (Object)CryptoModuleBuilder.this.cipherPadding);
                if (keyStoreUrl != null) {
                    props.put("cayenne.crypto.keystore.url", (Object)keyStoreUrl);
                }
                if (CryptoModuleBuilder.this.encryptionKeyAlias != null) {
                    props.put("cayenne.crypto.key.enc.alias", (Object)CryptoModuleBuilder.this.encryptionKeyAlias);
                }
                if (CryptoModuleBuilder.this.compress) {
                    props.put("cayenne.crypto.compression", (Object)"true");
                }
                MapBuilder creds = binder.bindMap("cayenne.crypto.properties");
                if (CryptoModuleBuilder.this.keyPassword != null) {
                    creds.put("cayenne.crypto.key.password", (Object)CryptoModuleBuilder.this.keyPassword);
                }
                binder.bind(CipherFactory.class).to(CryptoModuleBuilder.this.cipherFactoryType);
                binder.bind(TransformerFactory.class).to(DefaultTransformerFactory.class);
                binder.bind(ValueTransformerFactory.class).to(CryptoModuleBuilder.this.valueTransformerFactoryType);
                binder.bind(BytesTransformerFactory.class).to(CryptoModuleBuilder.this.bytesTransformerFactoryType);
                if (CryptoModuleBuilder.this.keySource != null) {
                    binder.bind(KeySource.class).toInstance((Object)CryptoModuleBuilder.this.keySource);
                } else {
                    binder.bind(KeySource.class).to(CryptoModuleBuilder.this.keySourceType);
                }
                if (CryptoModuleBuilder.this.columnMapperPattern != null) {
                    binder.bind(ColumnMapper.class).toInstance((Object)new PatternColumnMapper(CryptoModuleBuilder.this.columnMapperPattern));
                } else if (CryptoModuleBuilder.this.columnMapperType != null) {
                    binder.bind(ColumnMapper.class).to(CryptoModuleBuilder.this.columnMapperType);
                } else {
                    binder.bind(ColumnMapper.class).toInstance((Object)CryptoModuleBuilder.this.columnMapper);
                }
                binder.decorate(BatchTranslatorFactory.class).before(CryptoBatchTranslatorFactoryDecorator.class);
                binder.decorate(RowReaderFactory.class).before(CryptoRowReaderFactoryDecorator.class);
            }
        };
    }
}

