/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.util.Map;
import org.apache.cayenne.crypto.CayenneCryptoException;
import org.apache.cayenne.crypto.cipher.CipherFactory;
import org.apache.cayenne.crypto.key.KeySource;
import org.apache.cayenne.crypto.transformer.bytes.BytesDecryptor;
import org.apache.cayenne.crypto.transformer.bytes.BytesEncryptor;
import org.apache.cayenne.crypto.transformer.bytes.BytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.bytes.CbcBytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.bytes.Header;
import org.apache.cayenne.di.Inject;

public class DefaultBytesTransformerFactory
implements BytesTransformerFactory {
    private BytesTransformerFactory delegate;

    static Header createEncryptionHeader(Map<String, String> properties, KeySource keySource) {
        boolean compressed = "true".equals(properties.get("cayenne.crypto.compression"));
        return Header.create(keySource.getDefaultKeyAlias(), compressed);
    }

    public DefaultBytesTransformerFactory(@Inject(value="cayenne.crypto.properties") Map<String, String> properties, @Inject CipherFactory cipherFactory, @Inject KeySource keySource) {
        Header encryptionHeader = DefaultBytesTransformerFactory.createEncryptionHeader(properties, keySource);
        String mode = properties.get("cayenne.crypto.cipher.mode");
        if (mode == null) {
            throw new CayenneCryptoException("Cipher mode is not set. Property name: cayenne.crypto.cipher.mode", new Object[0]);
        }
        if (!"CBC".equals(mode)) {
            throw new CayenneCryptoException("Unsupported mode: " + mode + ". The following modes are currently supported:  CBC", new Object[0]);
        }
        this.delegate = new CbcBytesTransformerFactory(cipherFactory, keySource, encryptionHeader);
    }

    @Override
    public BytesEncryptor encryptor() {
        return this.delegate.encryptor();
    }

    @Override
    public BytesDecryptor decryptor() {
        return this.delegate.decryptor();
    }
}

