/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.Scope;
import org.apache.cayenne.di.spi.Binding;
import org.apache.cayenne.di.spi.ConstructorInjectingProvider;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.FieldInjectingProvider;
import org.apache.cayenne.di.spi.InstanceProvider;

public abstract class DICollectionBuilder<K, E> {
    protected DefaultInjector injector;
    protected Key<K> bindingKey;

    public DICollectionBuilder(Key<K> bindingKey, DefaultInjector injector) {
        this.injector = injector;
        this.bindingKey = bindingKey;
    }

    protected Provider<E> createInstanceProvider(E value) {
        InstanceProvider<E> provider0 = new InstanceProvider<E>(value);
        return new FieldInjectingProvider<E>(provider0, this.injector);
    }

    protected <SubT extends E> Provider<SubT> createTypeProvider(final Class<SubT> interfaceType) throws DIRuntimeException {
        return new Provider<SubT>(){

            @Override
            public SubT get() throws DIRuntimeException {
                return DICollectionBuilder.this.findOrCreateBinding(interfaceType).getScoped().get();
            }
        };
    }

    protected <SubT extends E> Binding<SubT> findOrCreateBinding(Class<SubT> interfaceType) {
        Key<SubT> key = Key.get(interfaceType);
        Binding<SubT> binding = this.injector.getBinding(key);
        if (binding == null) {
            ConstructorInjectingProvider<SubT> provider0 = new ConstructorInjectingProvider<SubT>(interfaceType, this.injector);
            FieldInjectingProvider<SubT> provider1 = new FieldInjectingProvider<SubT>(provider0, this.injector);
            this.injector.putBinding(key, provider1);
            binding = this.injector.getBinding(key);
        }
        return binding;
    }

    public void in(Scope scope) {
        this.injector.changeBindingScope(this.bindingKey, scope);
    }
}

