/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.Map;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Scope;
import org.apache.cayenne.di.spi.Binding;
import org.apache.cayenne.di.spi.ConstructorInjectingProvider;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.FieldInjectingProvider;
import org.apache.cayenne.di.spi.InstanceProvider;
import org.apache.cayenne.di.spi.MapProvider;

class DefaultMapBuilder<T>
implements MapBuilder<T> {
    private DefaultInjector injector;
    private Key<Map<String, ?>> bindingKey;

    DefaultMapBuilder(Key<Map<String, ?>> bindingKey, DefaultInjector injector) {
        this.injector = injector;
        this.bindingKey = bindingKey;
        this.getMapProvider();
    }

    @Override
    public MapBuilder<T> put(String key, Class<? extends T> interfaceType) throws DIRuntimeException {
        Key<? extends T> bindingKey = Key.get(interfaceType);
        Binding<T> binding = this.injector.getBinding(bindingKey);
        if (binding == null) {
            return this.putWithBinding(key, interfaceType);
        }
        this.getMapProvider().put(key, binding.getScoped());
        return this;
    }

    <K extends T> MapBuilder<T> putWithBinding(String key, Class<K> interfaceType) {
        Key<K> bindingKey = Key.get(interfaceType);
        ConstructorInjectingProvider<K> provider0 = new ConstructorInjectingProvider<K>(interfaceType, this.injector);
        FieldInjectingProvider<K> provider1 = new FieldInjectingProvider<K>(provider0, this.injector);
        this.injector.putBinding(bindingKey, provider1);
        this.getMapProvider().put(key, this.injector.getProvider(bindingKey));
        return this;
    }

    @Override
    public MapBuilder<T> put(String key, T value) throws DIRuntimeException {
        InstanceProvider<T> provider0 = new InstanceProvider<T>(value);
        FieldInjectingProvider<T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
        this.getMapProvider().put(key, provider1);
        return this;
    }

    @Override
    public MapBuilder<T> putAll(Map<String, T> map) throws DIRuntimeException {
        MapProvider provider = this.getMapProvider();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            InstanceProvider<T> provider0 = new InstanceProvider<T>(entry.getValue());
            FieldInjectingProvider<T> provider1 = new FieldInjectingProvider<T>(provider0, this.injector);
            provider.put(entry.getKey(), provider1);
        }
        return this;
    }

    private MapProvider getMapProvider() {
        MapProvider provider = null;
        Binding<Map<String, ?>> binding = this.injector.getBinding(this.bindingKey);
        if (binding == null) {
            provider = new MapProvider();
            this.injector.putBinding(this.bindingKey, provider);
        } else {
            provider = (MapProvider)binding.getOriginal();
        }
        return provider;
    }

    @Override
    public void in(Scope scope) {
        this.injector.changeBindingScope(this.bindingKey, scope);
    }
}

