/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.DIGraph;
import org.apache.cayenne.di.spi.ModuleProvider;

public class ModuleLoader {
    public List<Module> load() {
        HashMap<Class<? extends Module>, ModuleProvider> providers = new HashMap<Class<? extends Module>, ModuleProvider>();
        for (ModuleProvider moduleProvider : ServiceLoader.load(ModuleProvider.class)) {
            ModuleProvider moduleProvider2 = providers.put(moduleProvider.moduleType(), moduleProvider);
            if (moduleProvider2 == null || moduleProvider2.getClass().equals(moduleProvider.getClass())) continue;
            throw new DIRuntimeException("More than one provider for module type '%s': %s and %s", moduleProvider.moduleType().getName(), moduleProvider2.getClass().getName(), moduleProvider.getClass().getName());
        }
        if (providers.size() == 0) {
            return Collections.emptyList();
        }
        DIGraph<Object> overrideGraph = new DIGraph<Object>();
        for (Map.Entry entry : providers.entrySet()) {
            overrideGraph.add(entry.getKey());
            for (Class clazz : ((ModuleProvider)entry.getValue()).overrides()) {
                overrideGraph.add(entry.getKey(), clazz);
            }
        }
        List list = overrideGraph.topSort();
        ArrayList<Module> arrayList = new ArrayList<Module>(list.size());
        for (Class clazz : list) {
            arrayList.add(((ModuleProvider)providers.get(clazz)).module());
        }
        return arrayList;
    }
}

