/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.id;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityIdCoder {
    static final String UUID_SEPARATOR = ":";
    private String entityName;
    private SortedMap<String, Converter> converters;
    private int idSize;

    public static String getEntityName(String id) {
        int separator = id.indexOf(UUID_SEPARATOR);
        if (separator <= 0 || separator == id.length() - 1) {
            throw new IllegalArgumentException("Invalid uuid: " + id);
        }
        return id.substring(0, separator);
    }

    public EntityIdCoder(ObjEntity entity) {
        this.entityName = entity.getName();
        this.converters = new TreeMap<String, Converter>();
        for (ObjAttribute attribute : entity.getAttributes()) {
            if (!attribute.isPrimaryKey()) continue;
            this.converters.put(attribute.getDbAttributeName(), this.create(attribute.getJavaClass()));
        }
        for (ObjAttribute attribute : entity.getDbEntity().getPrimaryKeys()) {
            if (this.converters.containsKey(attribute.getName())) continue;
            String type = TypesMapping.getJavaBySqlType((int)attribute.getType());
            try {
                this.converters.put(attribute.getName(), this.create(Util.getJavaClass((String)type)));
            }
            catch (ClassNotFoundException e) {
                throw new CayenneRuntimeException("Can't instantiate class " + type, (Throwable)e, new Object[0]);
            }
        }
        if (this.converters.isEmpty()) {
            throw new IllegalArgumentException("Entity has no PK definied: " + entity.getName());
        }
        this.idSize = (int)Math.ceil((double)this.converters.size() / 0.75);
    }

    public String toStringId(ObjectId id) {
        if (id.isTemporary() && !id.isReplacementIdAttached()) {
            throw new IllegalArgumentException("Can't create UUID for a temporary ObjectId");
        }
        Map idValues = id.getIdSnapshot();
        StringBuilder buffer = new StringBuilder();
        buffer.append(id.getEntityName());
        for (Map.Entry<String, Converter> entry : this.converters.entrySet()) {
            Object value = idValues.get(entry.getKey());
            buffer.append(UUID_SEPARATOR).append(entry.getValue().toUuid(value));
        }
        return buffer.toString();
    }

    public ObjectId toObjectId(String uuid) {
        String uuidValues = uuid.substring(this.entityName.length() + 1);
        if (this.converters.size() == 1) {
            String decoded;
            Map.Entry<String, Converter> entry = this.converters.entrySet().iterator().next();
            try {
                decoded = URLDecoder.decode(uuidValues, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new CayenneRuntimeException("Unsupported encoding", (Throwable)e, new Object[0]);
            }
            return new ObjectId(this.entityName, entry.getKey(), entry.getValue().fromUuid(decoded));
        }
        HashMap<String, Object> idMap = new HashMap<String, Object>(this.idSize);
        StringTokenizer toks = new StringTokenizer(uuidValues, UUID_SEPARATOR);
        if (toks.countTokens() != this.converters.size()) {
            throw new IllegalArgumentException("Invalid UUID for entity " + this.entityName + ": " + uuidValues);
        }
        for (Map.Entry<String, Converter> entry : this.converters.entrySet()) {
            String decoded;
            String value = toks.nextToken();
            try {
                decoded = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new CayenneRuntimeException("Unsupported encoding", (Throwable)e, new Object[0]);
            }
            idMap.put(entry.getKey(), entry.getValue().fromUuid(decoded));
        }
        return new ObjectId(this.entityName, idMap);
    }

    private Converter create(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        if (Long.class.isAssignableFrom(type)) {
            return new Converter(){

                Object fromUuid(String uuid) {
                    return Long.valueOf(uuid);
                }
            };
        }
        if (Integer.class.isAssignableFrom(type)) {
            return new Converter(){

                Object fromUuid(String uuid) {
                    return Integer.valueOf(uuid);
                }
            };
        }
        if (String.class.isAssignableFrom(type)) {
            return new Converter(){

                Object fromUuid(String uuid) {
                    return uuid;
                }
            };
        }
        throw new IllegalArgumentException("Unsupported UUID type: " + type.getName());
    }

    abstract class Converter {
        Converter() {
        }

        String toUuid(Object value) {
            try {
                return URLEncoder.encode(String.valueOf(value), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new CayenneRuntimeException("Unsupported encoding", (Throwable)e, new Object[0]);
            }
        }

        abstract Object fromUuid(String var1);
    }
}

