/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.audit;

import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.annotation.PostPersist;
import org.apache.cayenne.annotation.PostRemove;
import org.apache.cayenne.annotation.PostUpdate;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.lifecycle.audit.Auditable;
import org.apache.cayenne.lifecycle.audit.AuditableAggregator;
import org.apache.cayenne.lifecycle.audit.AuditableChild;
import org.apache.cayenne.lifecycle.audit.AuditableOperation;
import org.apache.cayenne.lifecycle.audit.AuditableProcessor;
import org.apache.cayenne.query.Query;

public class AuditableFilter
implements DataChannelFilter {
    private ThreadLocal<AuditableAggregator> threadAggregator;
    protected AuditableProcessor processor;

    public AuditableFilter(AuditableProcessor processor) {
        this.processor = processor;
        this.threadAggregator = new ThreadLocal();
    }

    public void init(DataChannel channel) {
    }

    public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
        return filterChain.onQuery(originatingContext, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelFilterChain filterChain) {
        GraphDiff response;
        try {
            response = filterChain.onSync(originatingContext, changes, syncType);
            if (syncType == 2 || syncType == 1) {
                this.postSync();
            }
        }
        finally {
            this.cleanupPostSync();
        }
        return response;
    }

    protected void cleanupPostSync() {
        this.threadAggregator.set(null);
    }

    void postSync() {
        AuditableAggregator aggregator = this.threadAggregator.get();
        if (aggregator != null) {
            this.threadAggregator.set(null);
            aggregator.postSync();
        }
    }

    private AuditableAggregator getAggregator() {
        AuditableAggregator aggregator = this.threadAggregator.get();
        if (aggregator == null) {
            aggregator = new AuditableAggregator(this.processor);
            this.threadAggregator.set(aggregator);
        }
        return aggregator;
    }

    @PostPersist(entityAnnotations={Auditable.class})
    void insertAudit(Object object) {
        this.getAggregator().audit(object, AuditableOperation.INSERT);
    }

    @PostRemove(entityAnnotations={Auditable.class})
    void deleteAudit(Object object) {
        this.getAggregator().audit(object, AuditableOperation.DELETE);
    }

    @PostUpdate(entityAnnotations={Auditable.class})
    void updateAudit(Object object) {
        this.getAggregator().audit(object, AuditableOperation.UPDATE);
    }

    @PostUpdate(entityAnnotations={AuditableChild.class})
    void updateAuditChild(Object object) {
        Object parent = this.getParent(object);
        if (parent != null) {
            this.updateAudit(parent);
        }
    }

    protected Object getParent(Object object) {
        if (object == null) {
            throw new NullPointerException("Null object");
        }
        if (!(object instanceof DataObject)) {
            throw new IllegalArgumentException("Object is not a DataObject: " + object.getClass().getName());
        }
        DataObject dataObject = (DataObject)object;
        AuditableChild annotation = dataObject.getClass().getAnnotation(AuditableChild.class);
        if (annotation == null) {
            throw new IllegalArgumentException("No 'AuditableChild' annotation found");
        }
        return dataObject.readNestedProperty(annotation.value());
    }
}

