/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.ref;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.annotation.PostLoad;
import org.apache.cayenne.annotation.PostPersist;
import org.apache.cayenne.lifecycle.ref.Referenceable;
import org.apache.cayenne.lifecycle.uuid.UuidCoder;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;

public class ReferenceableHandler {
    protected EntityResolver entityResolver;
    protected Map<String, UuidCoder> coders;

    public ReferenceableHandler(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        this.coders = new ConcurrentHashMap<String, UuidCoder>();
    }

    public Object getReferenceable(ObjectContext context, String uuid) {
        String entityName = UuidCoder.getEntityName(uuid);
        UuidCoder coder = this.getCoder(entityName);
        ObjectId oid = coder.toObjectId(uuid);
        return Cayenne.objectForPK((ObjectContext)context, (ObjectId)oid);
    }

    public String getUuid(Object referenceable) {
        if (referenceable == null) {
            throw new NullPointerException("Null object");
        }
        if (referenceable instanceof DataObject) {
            DataObject dataObject = (DataObject)referenceable;
            String uuid = (String)dataObject.readPropertyDirectly("cayenne:uuid");
            if (uuid == null) {
                throw new IllegalArgumentException("No UUID set. An object is either not a Referenceable or is NEW or TRANSIENT.");
            }
            return uuid;
        }
        throw new IllegalArgumentException("Object is not a DataObject: " + referenceable.getClass().getName());
    }

    @PostLoad(entityAnnotations={Referenceable.class})
    @PostPersist(entityAnnotations={Referenceable.class})
    protected void initProperties(DataObject object) {
        UuidCoder coder = this.getCoder(object.getObjectId().getEntityName());
        String uuid = coder.toUuid(object.getObjectId());
        object.writePropertyDirectly("cayenne:uuid", (Object)uuid);
    }

    protected UuidCoder getCoder(String entityName) {
        UuidCoder coder = this.coders.get(entityName);
        if (coder == null) {
            ObjEntity entity = this.entityResolver.getObjEntity(entityName);
            if (entity == null) {
                throw new IllegalArgumentException("Entity '" + entityName + "' is not a known referenceable");
            }
            coder = new UuidCoder(entity);
            this.coders.put(entity.getName(), coder);
        }
        return coder;
    }
}

