/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.relationship;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.lifecycle.uuid.UuidCoder;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UuidBatchFault {
    private ObjectContext context;
    private Collection<String> uuids;
    private volatile Map<String, Object> resolved;

    UuidBatchFault(ObjectContext context) {
        this.context = context;
    }

    void addUuid(String uuid) {
        if (this.uuids == null) {
            this.uuids = new ArrayList<String>();
        }
        this.uuids.add(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> getObjects() {
        if (this.resolved == null) {
            UuidBatchFault uuidBatchFault = this;
            synchronized (uuidBatchFault) {
                if (this.resolved == null) {
                    this.resolved = this.fetchObjects();
                }
            }
        }
        return this.resolved;
    }

    private Map<String, Object> fetchObjects() {
        if (this.uuids == null) {
            return Collections.EMPTY_MAP;
        }
        EntityResolver resolver = this.context.getEntityResolver();
        if (this.uuids.size() == 1) {
            String uuid = this.uuids.iterator().next();
            String entityName = UuidCoder.getEntityName(uuid);
            ObjEntity entity = resolver.getObjEntity(entityName);
            ObjectId id = new UuidCoder(entity).toObjectId(uuid);
            Object object = Cayenne.objectForQuery((ObjectContext)this.context, (Query)new ObjectIdQuery(id));
            if (object == null) {
                return Collections.EMPTY_MAP;
            }
            return Collections.singletonMap(uuid, object);
        }
        HashMap<String, SelectQuery> queriesByEntity = new HashMap<String, SelectQuery>();
        HashMap<String, UuidCoder> codersByEntity = new HashMap<String, UuidCoder>();
        for (String uuid : this.uuids) {
            SelectQuery query;
            String entityName = UuidCoder.getEntityName(uuid);
            UuidCoder coder = (UuidCoder)codersByEntity.get(entityName);
            if (coder == null) {
                coder = new UuidCoder(resolver.getObjEntity(entityName));
                codersByEntity.put(entityName, coder);
                query = new SelectQuery(entityName);
                queriesByEntity.put(entityName, query);
            } else {
                query = (SelectQuery)queriesByEntity.get(entityName);
            }
            ObjectId id = coder.toObjectId(uuid);
            Expression idExp = ExpressionFactory.matchAllDbExp((Map)id.getIdSnapshot(), (int)3);
            query.orQualifier(idExp);
        }
        int capacity = (int)Math.ceil((double)this.uuids.size() / 0.75);
        HashMap<String, Object> results = new HashMap<String, Object>(capacity);
        for (SelectQuery query : queriesByEntity.values()) {
            UuidCoder coder = (UuidCoder)codersByEntity.get(query.getRoot());
            List objects = this.context.performQuery((Query)query);
            for (DataObject object : objects) {
                String uuid = coder.toUuid(object.getObjectId());
                results.put(uuid, object);
            }
        }
        return results;
    }
}

