/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.relationship;

import org.apache.cayenne.DataObject;
import org.apache.cayenne.lifecycle.relationship.UuidBatchFault;
import org.apache.cayenne.lifecycle.relationship.UuidFault;
import org.apache.cayenne.lifecycle.relationship.UuidRelationship;
import org.apache.cayenne.lifecycle.relationship.UuidRelationshipFaultingStrategy;

public class UuidRelationshipBatchFaultingStrategy
implements UuidRelationshipFaultingStrategy {
    private ThreadLocal<UuidBatchFault> batchFaultHolder = new ThreadLocal();

    public void afterObjectLoaded(DataObject object) {
        UuidBatchFault batchFault = this.batchFaultHolder.get();
        if (batchFault == null) {
            batchFault = new UuidBatchFault(object.getObjectContext());
            this.batchFaultHolder.set(batchFault);
        }
        String uuidProperty = this.uuidPropertyName(object);
        String uuidRelationship = this.uuidRelationshipName(uuidProperty);
        String uuid = (String)object.readProperty(uuidProperty);
        if (uuid == null) {
            object.writePropertyDirectly(uuidRelationship, null);
        } else {
            batchFault.addUuid(uuid);
            object.writePropertyDirectly(uuidRelationship, (Object)new UuidFault(batchFault, uuid));
        }
    }

    public void afterQuery() {
        this.batchFaultHolder.set(null);
    }

    String uuidRelationshipName(String uuidPropertyName) {
        return "cay:related:" + uuidPropertyName;
    }

    String uuidPropertyName(DataObject object) {
        UuidRelationship annotation = object.getClass().getAnnotation(UuidRelationship.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Object class is not annotated with 'MixinRelationship': " + object.getClass().getName());
        }
        return annotation.value();
    }
}

