/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.relationship;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.lifecycle.relationship.UuidBatchFault;
import org.apache.cayenne.lifecycle.relationship.UuidBatchSourceItem;
import org.apache.cayenne.lifecycle.relationship.UuidFault;
import org.apache.cayenne.lifecycle.relationship.UuidRelationship;
import org.apache.cayenne.lifecycle.relationship.UuidRelationshipFaultingStrategy;

public class UuidRelationshipBatchFaultingStrategy
implements UuidRelationshipFaultingStrategy {
    private ThreadLocal<List<UuidBatchSourceItem>> batchSources = new ThreadLocal();

    public void afterObjectLoaded(DataObject object) {
        String uuidProperty = this.uuidPropertyName(object);
        String uuidRelationship = this.uuidRelationshipName(uuidProperty);
        String uuid = (String)object.readProperty(uuidProperty);
        if (uuid == null) {
            object.writePropertyDirectly(uuidRelationship, null);
        } else {
            List<UuidBatchSourceItem> sources = this.batchSources.get();
            if (sources == null) {
                sources = new ArrayList<UuidBatchSourceItem>();
                this.batchSources.set(sources);
            }
            sources.add(new UuidBatchSourceItem(object, uuid, uuidRelationship));
        }
    }

    public void afterQuery() {
        List<UuidBatchSourceItem> sources = this.batchSources.get();
        if (sources != null) {
            this.batchSources.set(null);
            UuidBatchFault batchFault = new UuidBatchFault(sources.get(0).getObject().getObjectContext(), sources);
            for (UuidBatchSourceItem source : sources) {
                source.getObject().writePropertyDirectly(source.getUuidRelationship(), (Object)new UuidFault(batchFault, source.getUuid()));
            }
        }
    }

    String uuidRelationshipName(String uuidPropertyName) {
        return "cay:related:" + uuidPropertyName;
    }

    String uuidPropertyName(DataObject object) {
        UuidRelationship annotation = object.getClass().getAnnotation(UuidRelationship.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Object class is not annotated with @UuidRelationship: " + object.getClass().getName());
        }
        return annotation.value();
    }
}

