/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.relationship;

import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.annotation.PostLoad;
import org.apache.cayenne.annotation.PostPersist;
import org.apache.cayenne.annotation.PostUpdate;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.lifecycle.relationship.UuidRelationship;
import org.apache.cayenne.lifecycle.relationship.UuidRelationshipBatchFaultingStrategy;
import org.apache.cayenne.lifecycle.relationship.UuidRelationshipFaultingStrategy;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;

public class UuidRelationshipFilter
implements DataChannelFilter {
    private UuidRelationshipFaultingStrategy faultingStrategy;

    public void init(DataChannel channel) {
        this.faultingStrategy = this.createFaultingStrategy();
        this.registerUuidRelationships(channel);
    }

    protected void registerUuidRelationships(DataChannel channel) {
        EntityResolver resolver = channel.getEntityResolver();
        for (ObjEntity entity : resolver.getObjEntities()) {
            Class type = resolver.getClassDescriptor(entity.getName()).getObjectClass();
            UuidRelationship a = type.getAnnotation(UuidRelationship.class);
            if (a == null) continue;
        }
    }

    protected UuidRelationshipFaultingStrategy createFaultingStrategy() {
        return new UuidRelationshipBatchFaultingStrategy();
    }

    public GraphDiff onSync(ObjectContext context, GraphDiff diff, int syncType, DataChannelFilterChain chain) {
        return chain.onSync(context, diff, syncType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResponse onQuery(ObjectContext context, Query query, DataChannelFilterChain chain) {
        try {
            QueryResponse queryResponse = chain.onQuery(context, query);
            return queryResponse;
        }
        finally {
            this.faultingStrategy.afterQuery();
        }
    }

    @PostUpdate(entityAnnotations={UuidRelationship.class})
    @PostPersist(entityAnnotations={UuidRelationship.class})
    void postCommit(DataObject object) {
        object.getObjectContext().invalidateObjects((Object[])new DataObject[]{object});
    }

    @PostLoad(entityAnnotations={UuidRelationship.class})
    void postLoad(DataObject object) {
        this.faultingStrategy.afterObjectLoaded(object);
    }
}

