/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.ParameterizedQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryMetadataWrapper;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.Util;

@Deprecated
public class NamedQuery
extends IndirectQuery {
    protected Map<String, Object> parameters;
    protected boolean forceNoCache;
    protected BaseQueryMetadata overrideMetadata;
    transient int hashCode;

    private NamedQuery() {
    }

    public NamedQuery(String name) {
        this(name, null);
    }

    public NamedQuery(String name, Map<String, ?> parameters) {
        this.name = name;
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters = new HashMap(parameters);
        }
    }

    public NamedQuery(String name, String[] keys, Object[] values) {
        this.name = name;
        this.parameters = Util.toMap(keys, values);
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        QueryMetadata base = this.overrideMetadata != null ? this.overrideMetadata : super.getMetaData(resolver);
        QueryMetadataWrapper wrapper = new QueryMetadataWrapper(base);
        if (this.forceNoCache) {
            QueryCacheStrategy strategy = base.getCacheStrategy();
            if (QueryCacheStrategy.LOCAL_CACHE == strategy) {
                wrapper.override("cayenne.GenericSelectQuery.cacheStrategy", (Object)QueryCacheStrategy.LOCAL_CACHE_REFRESH);
            } else if (QueryCacheStrategy.SHARED_CACHE == strategy) {
                wrapper.override("cayenne.GenericSelectQuery.cacheStrategy", (Object)QueryCacheStrategy.SHARED_CACHE_REFRESH);
            }
        }
        if (this.parameters != null && !this.parameters.isEmpty() && this.replacementQuery instanceof NamedQuery && base.getCacheKey() != null) {
            StringBuilder buffer = new StringBuilder(this.name);
            if (this.parameters != null && !this.parameters.isEmpty()) {
                buffer.append(this.parameters.hashCode());
            }
            wrapper.override("QueryMetadataWrapper.CacheKey", buffer.toString());
        }
        return wrapper;
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        Query query = this.resolveQuery(resolver);
        if (query instanceof ParameterizedQuery) {
            query = ((ParameterizedQuery)query).createQuery(this.normalizedParameters());
        } else if (query instanceof EJBQLQuery) {
            for (Map.Entry<String, ?> pairs : this.normalizedParameters().entrySet()) {
                ((EJBQLQuery)query).setParameter(pairs.getKey(), pairs.getValue());
            }
        }
        return query;
    }

    Map<String, ?> normalizedParameters() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> substitutes = new HashMap<String, Object>(this.parameters);
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Persistent) {
                value = ((Persistent)value).getObjectId();
            }
            substitutes.put(entry.getKey(), value);
        }
        return substitutes;
    }

    protected Query resolveQuery(EntityResolver resolver) {
        QueryDescriptor queryDescriptor = resolver.getQueryDescriptor(this.getName());
        Query query = queryDescriptor.buildQuery();
        if (query == this) {
            throw new CayenneRuntimeException("Named query resolves to self: '%s'", this.getName());
        }
        return query;
    }

    public String toString() {
        String className = this.getClass().getName();
        return Util.stripPackageName(className) + ":" + this.getName();
    }

    public void initMetadata(QueryMetadata metadata) {
        if (metadata != null) {
            this.overrideMetadata = new BaseQueryMetadata();
            this.overrideMetadata.copyFromInfo(metadata);
        } else {
            this.overrideMetadata = null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NamedQuery)) {
            return false;
        }
        NamedQuery query = (NamedQuery)object;
        if (!Util.nullSafeEquals(this.name, query.getName())) {
            return false;
        }
        if (query.parameters == null && this.parameters == null) {
            return true;
        }
        if (query.parameters == null || this.parameters == null) {
            return false;
        }
        if (query.parameters.size() != this.parameters.size()) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            String entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryValue == null) {
                if (query.parameters.get(entryKey) == null && query.parameters.containsKey(entryKey)) continue;
                return false;
            }
            builder.append(entryValue, query.parameters.get(entryKey));
            if (builder.isEquals()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder(13, 17);
            if (this.name != null) {
                builder.append(this.name.hashCode());
            }
            if (this.parameters != null) {
                Object[] keys = this.parameters.keySet().toArray();
                Arrays.sort(keys);
                for (Object key : keys) {
                    builder.append(key).append(this.parameters.get(key));
                }
            }
            this.hashCode = builder.toHashCode();
            assert (this.hashCode != 0) : "Generated zero hashCode";
        }
        return this.hashCode;
    }

    public boolean isForceNoCache() {
        return this.forceNoCache;
    }

    public void setForceNoCache(boolean forcingNoCache) {
        this.forceNoCache = forcingNoCache;
    }
}

