/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.DataChannelSyncCallbackAction;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionalOperation;

public class TransactionFilter
implements DataChannelFilter {
    @Inject
    protected TransactionManager transactionManager;

    @Override
    public void init(DataChannel channel) {
    }

    @Override
    public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
        return filterChain.onQuery(originatingContext, query);
    }

    @Override
    public GraphDiff onSync(final ObjectContext originatingContext, final GraphDiff changes, final int syncType, final DataChannelFilterChain filterChain) {
        GraphDiff result;
        DataChannelSyncCallbackAction callbackAction = DataChannelSyncCallbackAction.getCallbackAction(originatingContext.getChannel().getEntityResolver().getCallbackRegistry(), originatingContext.getGraphManager(), changes, syncType);
        callbackAction.applyPreCommit();
        switch (syncType) {
            case 3: {
                result = filterChain.onSync(originatingContext, changes, syncType);
                break;
            }
            case 1: 
            case 2: {
                result = this.transactionManager.performInTransaction(new TransactionalOperation<GraphDiff>(){

                    @Override
                    public GraphDiff perform() {
                        return filterChain.onSync(originatingContext, changes, syncType);
                    }
                });
                break;
            }
            default: {
                throw new CayenneRuntimeException("Invalid synchronization type: %d", syncType);
            }
        }
        callbackAction.applyPostCommit();
        return result;
    }
}

