/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.BaseContext;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.RelationshipQuery;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.ListResponse;
import org.apache.cayenne.util.ShallowMergeOperation;

public abstract class ObjectContextQueryAction {
    protected static final boolean DONE = true;
    protected ObjectContext targetContext;
    protected ObjectContext actingContext;
    protected Query query;
    protected QueryMetadata metadata;
    protected boolean queryOriginator;
    protected transient QueryResponse response;

    public ObjectContextQueryAction(ObjectContext actingContext, ObjectContext targetContext, Query query) {
        this.actingContext = actingContext;
        this.query = query;
        this.queryOriginator = targetContext != null && targetContext == actingContext;
        this.targetContext = targetContext != actingContext ? targetContext : null;
        this.metadata = query.getMetaData(actingContext.getEntityResolver());
    }

    public QueryResponse execute() {
        if (!(this.interceptOIDQuery() || this.interceptRelationshipQuery() || this.interceptRefreshQuery() || this.interceptLocalCache())) {
            this.executePostCache();
        }
        this.interceptObjectConversion();
        return this.response;
    }

    private void executePostCache() {
        if (!this.interceptInternalQuery() && !this.interceptPaginatedQuery()) {
            this.runQuery();
        }
    }

    protected void interceptObjectConversion() {
        if (this.targetContext != null && !this.metadata.isFetchingDataRows()) {
            GenericResponse childResponse = new GenericResponse();
            ShallowMergeOperation merger = null;
            this.response.reset();
            while (this.response.next()) {
                if (this.response.isList()) {
                    List<?> objects = this.response.currentList();
                    if (objects.isEmpty()) {
                        childResponse.addResultList(objects);
                        continue;
                    }
                    if (merger == null) {
                        merger = new ShallowMergeOperation(this.targetContext);
                    }
                    ArrayList<Persistent> childObjects = new ArrayList<Persistent>(objects.size());
                    for (Object object1 : objects) {
                        Persistent object = (Persistent)object1;
                        childObjects.add(merger.merge(object));
                    }
                    childResponse.addResultList(childObjects);
                    continue;
                }
                childResponse.addBatchUpdateCount(this.response.currentUpdateCount());
            }
            this.response = childResponse;
        }
    }

    protected boolean interceptInternalQuery() {
        return false;
    }

    protected boolean interceptOIDQuery() {
        Object object;
        ObjectIdQuery oidQuery;
        if (this.query instanceof ObjectIdQuery && !(oidQuery = (ObjectIdQuery)this.query).isFetchMandatory() && !oidQuery.isFetchingDataRows() && (object = this.polymorphicObjectFromCache(oidQuery.getObjectId())) != null) {
            if (((Persistent)object).getPersistenceState() == 5) {
                return false;
            }
            this.response = new ListResponse(object);
            return true;
        }
        return false;
    }

    protected Object polymorphicObjectFromCache(ObjectId superOid) {
        Object object = this.actingContext.getGraphManager().getNode(superOid);
        if (object != null) {
            return object;
        }
        EntityInheritanceTree inheritanceTree = this.actingContext.getEntityResolver().getInheritanceTree(superOid.getEntityName());
        if (!inheritanceTree.getChildren().isEmpty()) {
            object = this.polymorphicObjectFromCache(inheritanceTree, superOid.getIdSnapshot());
        }
        return object;
    }

    private Object polymorphicObjectFromCache(EntityInheritanceTree superNode, Map<String, ?> idSnapshot) {
        for (EntityInheritanceTree child : superNode.getChildren()) {
            ObjectId id = new ObjectId(child.getEntity().getName(), idSnapshot);
            Object object = this.actingContext.getGraphManager().getNode(id);
            if (object != null) {
                return object;
            }
            object = this.polymorphicObjectFromCache(child, idSnapshot);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    protected boolean interceptRelationshipQuery() {
        RelationshipQuery relationshipQuery;
        if (this.query instanceof RelationshipQuery && !(relationshipQuery = (RelationshipQuery)this.query).isRefreshing()) {
            ClassDescriptor descriptor;
            if (this.targetContext == null && relationshipQuery.getRelationship(this.actingContext.getEntityResolver()).isToMany()) {
                return false;
            }
            ObjectId id = relationshipQuery.getObjectId();
            Object object = this.actingContext.getGraphManager().getNode(id);
            if (object != null && !(descriptor = this.actingContext.getEntityResolver().getClassDescriptor(id.getEntityName())).isFault(object)) {
                ArcProperty property = (ArcProperty)descriptor.getProperty(relationshipQuery.getRelationshipName());
                if (!property.isFault(object)) {
                    List<Object> result;
                    Object related = property.readPropertyDirectly(object);
                    if (related == null) {
                        result = new ArrayList(1);
                    } else if (related instanceof List) {
                        result = (List)related;
                    } else if (related instanceof Set) {
                        result = new ArrayList((Set)related);
                    } else if (related instanceof Map) {
                        result = new ArrayList(((Map)related).values());
                    } else {
                        result = new ArrayList(1);
                        result.add(related);
                    }
                    this.response = new ListResponse(result);
                    return true;
                }
                if (((Persistent)object).getPersistenceState() == 2 && !(this.actingContext.getChannel() instanceof BaseContext)) {
                    this.response = new ListResponse();
                    return true;
                }
            }
        }
        return false;
    }

    protected abstract boolean interceptPaginatedQuery();

    protected abstract boolean interceptRefreshQuery();

    protected boolean interceptLocalCache() {
        boolean cacheOrCacheRefresh;
        if (this.metadata.getCacheKey() == null) {
            return false;
        }
        if (!this.queryOriginator) {
            return false;
        }
        boolean cache = QueryCacheStrategy.LOCAL_CACHE == this.metadata.getCacheStrategy();
        boolean bl = cacheOrCacheRefresh = cache || QueryCacheStrategy.LOCAL_CACHE_REFRESH == this.metadata.getCacheStrategy();
        if (!cacheOrCacheRefresh) {
            return false;
        }
        QueryCache queryCache = this.getQueryCache();
        QueryCacheEntryFactory factory = this.getCacheObjectFactory();
        if (cache) {
            List cachedResults = queryCache.get(this.metadata, factory);
            if (this.response == null) {
                this.response = new ListResponse(cachedResults);
            }
        } else {
            queryCache.put(this.metadata, factory.createObject());
        }
        return true;
    }

    protected QueryCache getQueryCache() {
        return ((BaseContext)this.actingContext).getQueryCache();
    }

    protected QueryCacheEntryFactory getCacheObjectFactory() {
        return new QueryCacheEntryFactory(){

            @Override
            public List createObject() {
                ObjectContextQueryAction.this.executePostCache();
                return ObjectContextQueryAction.this.response.firstList();
            }
        };
    }

    protected void runQuery() {
        this.response = this.actingContext.getChannel().onQuery(this.actingContext, this.query);
    }
}

