/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.commons.collections.map.LRUMap;

public class MapQueryCache
implements QueryCache,
Serializable {
    public static final int DEFAULT_CACHE_SIZE = 2000;
    protected Map<String, CacheEntry> map;

    public MapQueryCache() {
        this(2000);
    }

    public MapQueryCache(int maxSize) {
        this.map = new LRUMap(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List get(QueryMetadata metadata) {
        CacheEntry entry;
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        MapQueryCache mapQueryCache = this;
        synchronized (mapQueryCache) {
            entry = this.map.get(key);
        }
        return entry != null ? entry.list : null;
    }

    @Override
    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        List result = this.get(metadata);
        if (result == null) {
            List newObject = factory.createObject();
            if (newObject == null) {
                throw new CayenneRuntimeException("Null on cache rebuilding: " + metadata.getCacheKey(), new Object[0]);
            }
            result = newObject;
            this.put(metadata, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(QueryMetadata metadata, List results) {
        String key = metadata.getCacheKey();
        if (key != null) {
            CacheEntry entry = new CacheEntry();
            entry.list = results;
            entry.cacheGroup = metadata.getCacheGroup();
            MapQueryCache mapQueryCache = this;
            synchronized (mapQueryCache) {
                this.map.put(key, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        if (key != null) {
            MapQueryCache mapQueryCache = this;
            synchronized (mapQueryCache) {
                this.map.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(String groupKey) {
        if (groupKey != null) {
            MapQueryCache mapQueryCache = this;
            synchronized (mapQueryCache) {
                Iterator<CacheEntry> it = this.map.values().iterator();
                while (it.hasNext()) {
                    CacheEntry entry = it.next();
                    if (entry.cacheGroup == null || !groupKey.equals(entry.cacheGroup)) continue;
                    it.remove();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        MapQueryCache mapQueryCache = this;
        synchronized (mapQueryCache) {
            this.map.clear();
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    static final class CacheEntry
    implements Serializable {
        List<?> list;
        String cacheGroup;

        CacheEntry() {
        }
    }
}

