/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.io.IOException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.PatternMatchNode;

class MySQLQualifierTranslator
extends QualifierTranslator {
    public MySQLQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    @Override
    protected void appendLikeEscapeCharacter(PatternMatchNode patternMatchNode) throws IOException {
        char escapeChar = patternMatchNode.getEscapeChar();
        if ('?' == escapeChar) {
            throw new CayenneRuntimeException("the escape character of '?' is illegal for LIKE clauses.", new Object[0]);
        }
        if ('\u0000' != escapeChar) {
            this.out.append(" ESCAPE '");
            this.out.append(escapeChar);
            this.out.append("'");
        }
    }

    @Override
    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        if (!this.caseInsensitive) {
            super.finishedChild(node, childIndex, hasMoreChildren);
        } else {
            if (!hasMoreChildren) {
                return;
            }
            if (node.getType() != 11 && node.getType() != 37) {
                super.finishedChild(node, childIndex, hasMoreChildren);
                return;
            }
            try {
                StringBuilder out = this.matchingObject ? new StringBuilder() : this.out;
                switch (node.getType()) {
                    case 11: {
                        out.append((CharSequence)" LIKE BINARY ");
                        break;
                    }
                    case 37: {
                        out.append((CharSequence)" NOT LIKE BINARY ");
                    }
                }
            }
            catch (IOException ioex) {
                throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
            }
        }
    }
}

