/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.naming.NamingStrategy;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.tools.NamePatternMatcher;
import org.apache.cayenne.tools.dbimport.DbImportDbLoaderDelegate;
import org.apache.cayenne.tools.dbimport.DbImportParameters;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.EntityMergeSupport;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;

public class DbImportAction {
    private static final String DATA_MAP_LOCATION_SUFFIX = ".map.xml";
    private ProjectSaver projectSaver;
    private DataSourceFactory dataSourceFactory;
    private DbAdapterFactory adapterFactory;
    private Log logger;

    public DbImportAction(@Inject Log logger, @Inject DbAdapterFactory adapterFactory, @Inject DataSourceFactory dataSourceFactory, @Inject ProjectSaver projectSaver) {
        this.logger = logger;
        this.adapterFactory = adapterFactory;
        this.dataSourceFactory = dataSourceFactory;
        this.projectSaver = projectSaver;
    }

    public void execute(DbImportParameters parameters) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.debug((Object)String.format("DB connection - [driver: %s, url: %s, username: %s, password: %s]", parameters.getDriver(), parameters.getUrl(), parameters.getUsername(), "XXXXX"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Importer options - map: " + parameters.getDataMapFile()));
            this.logger.debug((Object)("Importer options - overwrite: " + parameters.isOverwrite()));
            this.logger.debug((Object)("Importer options - adapter: " + parameters.getAdapter()));
            this.logger.debug((Object)("Importer options - catalog: " + parameters.getCatalog()));
            this.logger.debug((Object)("Importer options - schema: " + parameters.getSchema()));
            this.logger.debug((Object)("Importer options - defaultPackage: " + parameters.getDefaultPackage()));
            this.logger.debug((Object)("Importer options - tablePattern: " + parameters.getTablePattern()));
            this.logger.debug((Object)("Importer options - importProcedures: " + parameters.isImportProcedures()));
            this.logger.debug((Object)("Importer options - procedurePattern: " + parameters.getProcedurePattern()));
            this.logger.debug((Object)("Importer options - meaningfulPkTables: " + parameters.getMeaningfulPkTables()));
            this.logger.debug((Object)("Importer options - namingStrategy: " + parameters.getNamingStrategy()));
            this.logger.debug((Object)("Importer options - includeTables: " + parameters.getIncludeTables()));
            this.logger.debug((Object)("Importer options - excludeTables: " + parameters.getExcludeTables()));
        }
        DataSourceInfo dataSourceInfo = new DataSourceInfo();
        dataSourceInfo.setDataSourceUrl(parameters.getUrl());
        dataSourceInfo.setJdbcDriver(parameters.getDriver());
        dataSourceInfo.setUserName(parameters.getUsername());
        dataSourceInfo.setPassword(parameters.getPassword());
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setAdapterType(parameters.getAdapter());
        nodeDescriptor.setDataSourceDescriptor(dataSourceInfo);
        DataMap dataMap = this.load(parameters, nodeDescriptor);
        this.saveLoaded(dataMap, parameters.getDataMapFile());
    }

    void saveLoaded(DataMap dataMap, File dataMapFile) throws FileNotFoundException {
        ConfigurationTree projectRoot = new ConfigurationTree((ConfigurationNode)dataMap);
        Project project = new Project(projectRoot);
        this.projectSaver.save(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataMap load(DbImportParameters parameters, DataNodeDescriptor nodeDescriptor) throws Exception {
        DataSource dataSource = this.dataSourceFactory.getDataSource(nodeDescriptor);
        DbAdapter adapter = this.adapterFactory.createAdapter(nodeDescriptor, dataSource);
        DataMap dataMap = this.createDataMap(parameters);
        DbImportDbLoaderDelegate loaderDelegate = new DbImportDbLoaderDelegate();
        Connection connection = dataSource.getConnection();
        try {
            DbLoader loader = this.createLoader(parameters, adapter, connection, loaderDelegate);
            String[] types = loader.getDefaultTableTypes();
            loader.load(dataMap, parameters.getCatalog(), parameters.getSchema(), parameters.getTablePattern(), types);
            for (ObjEntity addedObjEntity : loaderDelegate.getAddedObjEntities()) {
                DeleteRuleUpdater.updateObjEntity((ObjEntity)addedObjEntity);
            }
            if (parameters.isImportProcedures()) {
                loader.loadProcedures(dataMap, parameters.getCatalog(), parameters.getSchema(), parameters.getProcedurePattern());
            }
        }
        finally {
            connection.close();
        }
        return dataMap;
    }

    DbLoader createLoader(final DbImportParameters parameters, DbAdapter adapter, Connection connection, DbLoaderDelegate loaderDelegate) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        final NamePatternMatcher nameFilter = new NamePatternMatcher(this.logger, parameters.getIncludeTables(), parameters.getExcludeTables());
        String meangfulPkExclude = parameters.getMeaningfulPkTables() != null ? null : "*";
        final NamePatternMatcher meaningfulPkFilter = new NamePatternMatcher(this.logger, parameters.getMeaningfulPkTables(), meangfulPkExclude);
        DbLoader loader = new DbLoader(connection, adapter, loaderDelegate){

            public boolean includeTableName(String tableName) {
                return nameFilter.isIncluded(tableName);
            }

            protected EntityMergeSupport createEntityMerger(DataMap map) {
                EntityMergeSupport emSupport = new EntityMergeSupport(map, this.namingStrategy, true){

                    protected boolean removePK(DbEntity dbEntity) {
                        return !meaningfulPkFilter.isIncluded(dbEntity.getName());
                    }
                };
                emSupport.setUsePrimitives(parameters.isUsePrimitives());
                return emSupport;
            }
        };
        String namingStrategy = parameters.getNamingStrategy();
        if (namingStrategy != null) {
            NamingStrategy namingStrategyInst = (NamingStrategy)Class.forName(namingStrategy).newInstance();
            loader.setNamingStrategy(namingStrategyInst);
        }
        return loader;
    }

    DataMap createDataMap(DbImportParameters parameters) throws IOException {
        String schema;
        String catalog;
        DataMap dataMap;
        File dataMapFile = parameters.getDataMapFile();
        if (dataMapFile == null) {
            throw new NullPointerException("Null DataMap File.");
        }
        String name = dataMapFile.getName();
        if (!name.endsWith(DATA_MAP_LOCATION_SUFFIX)) {
            throw new CayenneRuntimeException("DataMap file name must end with '%s': '%s'", new Object[]{DATA_MAP_LOCATION_SUFFIX, name});
        }
        if (dataMapFile.exists()) {
            InputSource in = new InputSource(dataMapFile.getCanonicalPath());
            dataMap = new MapLoader().loadDataMap(in);
            if (parameters.isOverwrite()) {
                dataMap.clearObjEntities();
                dataMap.clearEmbeddables();
                dataMap.clearProcedures();
                dataMap.clearDbEntities();
                dataMap.clearQueries();
                dataMap.clearResultSets();
            }
        } else {
            String dataMapName = name.substring(0, name.length() - DATA_MAP_LOCATION_SUFFIX.length());
            dataMap = new DataMap(dataMapName);
        }
        URL dataMapUrl = dataMapFile.toURI().toURL();
        dataMap.setConfigurationSource((Resource)new URLResource(dataMapUrl));
        String defaultPackage = parameters.getDefaultPackage();
        if (defaultPackage != null && defaultPackage.length() > 0) {
            dataMap.setDefaultPackage(defaultPackage);
        }
        if ((catalog = parameters.getCatalog()) != null && catalog.length() > 0 && catalog.indexOf(37) < 0) {
            dataMap.setDefaultCatalog(catalog);
        }
        if ((schema = parameters.getSchema()) != null && schema.length() > 0 && schema.indexOf(37) < 0) {
            dataMap.setDefaultSchema(schema);
        }
        return dataMap;
    }
}

