/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionParameter;
import org.apache.cayenne.exp.parser.ASTList;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.PathComponent;
import org.apache.cayenne.map.naming.NameConverter;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.commons.collections.set.ListOrderedSet;

public class DataMapUtils {
    Map<String, Map<String, String>> queriesMap = new HashMap<String, Map<String, String>>();

    public String getQueryMethodName(Query query) {
        return NameConverter.underscoredToJava((String)query.getName(), (boolean)true);
    }

    public Collection getParameterNames(SelectQuery<?> query) {
        if (query.getQualifier() == null) {
            return Collections.EMPTY_SET;
        }
        Map<String, String> queryParameters = this.queriesMap.get(query.getName());
        if (queryParameters == null) {
            queryParameters = this.getParameterNames(query.getQualifier(), query.getRoot());
            this.queriesMap.put(query.getName(), queryParameters);
        }
        return this.parseQualifier(query.getQualifier().toString());
    }

    public Boolean isValidParameterNames(SelectQuery<?> query) {
        if (query.getQualifier() == null) {
            return true;
        }
        Map<String, String> queryParameters = this.queriesMap.get(query.getName());
        if (queryParameters == null) {
            try {
                queryParameters = this.getParameterNames(query.getQualifier(), query.getRoot());
            }
            catch (Exception e) {
                return false;
            }
        }
        if (query instanceof SelectQuery) {
            for (Ordering ordering : query.getOrderings()) {
                String path = ordering.getSortSpecString();
                Iterator it = ((ObjEntity)query.getRoot()).resolvePathComponents(path);
                while (it.hasNext()) {
                    try {
                        it.next();
                    }
                    catch (ExpressionException e) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private Set parseQualifier(String qualifierString) {
        ListOrderedSet result = new ListOrderedSet();
        Pattern pattern = Pattern.compile("\\$[\\w]+");
        Matcher matcher = pattern.matcher(qualifierString);
        while (matcher.find()) {
            String name = matcher.group();
            result.add(NameConverter.underscoredToJava((String)name.substring(1), (boolean)false));
        }
        return result;
    }

    public boolean hasParameters(SelectQuery<?> query) {
        Map<String, String> queryParameters = this.queriesMap.get(query.getName());
        if (queryParameters == null) {
            return false;
        }
        return queryParameters.keySet().size() > 0;
    }

    public String getParameterType(SelectQuery<?> query, String name) {
        return this.queriesMap.get(query.getName()).get(name);
    }

    private Map<String, String> getParameterNames(Expression expression, Object root) {
        if (expression != null) {
            HashMap<String, String> types = new HashMap<String, String>();
            String typeName = "";
            LinkedList<String> names = new LinkedList<String>();
            for (int i = 0; i < expression.getOperandCount(); ++i) {
                Object operand = expression.getOperand(i);
                if (operand instanceof Expression) {
                    types.putAll(this.getParameterNames((Expression)operand, root));
                }
                if (operand instanceof ASTObjPath) {
                    ObjRelationship relationship;
                    PathComponent component = ((Entity)root).lastPathComponent((Expression)((ASTObjPath)operand), null);
                    ObjAttribute attribute = (ObjAttribute)component.getAttribute();
                    typeName = attribute != null ? attribute.getType() : ((relationship = (ObjRelationship)component.getRelationship()) != null ? relationship.getTargetEntity().getClassName() : "Object");
                }
                if (operand instanceof ASTList) {
                    Object[] values;
                    for (Object value : values = (Object[])((ASTList)operand).getOperand(0)) {
                        if (!(value instanceof ExpressionParameter)) continue;
                        names.add(((ExpressionParameter)value).getName());
                    }
                }
                if (!(operand instanceof ExpressionParameter)) continue;
                names.add(((ExpressionParameter)operand).getName());
            }
            for (String name : names) {
                types.put(NameConverter.underscoredToJava((String)name, (boolean)false), typeName);
            }
            return types;
        }
        return Collections.EMPTY_MAP;
    }
}

