/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import foundrylogic.vpp.VPPConfig;
import java.io.File;
import org.apache.cayenne.access.loader.NameFilter;
import org.apache.cayenne.access.loader.NamePatternMatcher;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.tools.AntLogger;
import org.apache.cayenne.tools.CayenneGeneratorEntityFilterAction;
import org.apache.cayenne.tools.CayenneGeneratorMapLoaderAction;
import org.apache.cayenne.tools.CayenneTask;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.apache.velocity.VelocityContext;

public class CayenneGeneratorTask
extends CayenneTask {
    protected String includeEntitiesPattern;
    protected String excludeEntitiesPattern;
    protected VPPConfig vppConfig;
    protected File map;
    protected File[] additionalMaps;
    protected boolean client;
    protected File destDir;
    protected String encoding;
    protected boolean makepairs = true;
    protected String mode = ArtifactsGenerationMode.ENTITY.getLabel();
    protected String outputPattern = "*.java";
    protected boolean overwrite;
    protected String superpkg;
    protected String supertemplate;
    protected String template;
    protected String embeddabletemplate;
    protected String embeddablesupertemplate;
    protected String querytemplate;
    protected String querysupertemplate;
    protected boolean usepkgpath = true;

    protected VelocityContext getVppContext() {
        this.initializeVppConfig();
        return this.vppConfig.getVelocityContext();
    }

    protected ClassGenerationAction createGeneratorAction() {
        ClassGenerationAction action = this.client ? new ClientClassGenerationAction() : new ClassGenerationAction();
        action.setContext(this.getVppContext());
        action.setDestDir(this.destDir);
        action.setEncoding(this.encoding);
        action.setMakePairs(this.makepairs);
        action.setArtifactsGenerationMode(this.mode);
        action.setOutputPattern(this.outputPattern);
        action.setOverwrite(this.overwrite);
        action.setSuperPkg(this.superpkg);
        action.setSuperTemplate(this.supertemplate);
        action.setTemplate(this.template);
        action.setEmbeddableSuperTemplate(this.embeddablesupertemplate);
        action.setEmbeddableTemplate(this.embeddabletemplate);
        action.setQueryTemplate(this.querytemplate);
        action.setQuerySuperTemplate(this.querysupertemplate);
        action.setUsePkgPath(this.usepkgpath);
        return action;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        AntLogger logger = new AntLogger(this);
        CayenneGeneratorMapLoaderAction loadAction = new CayenneGeneratorMapLoaderAction();
        loadAction.setMainDataMapFile(this.map);
        loadAction.setAdditionalDataMapFiles(this.additionalMaps);
        CayenneGeneratorEntityFilterAction filterAction = new CayenneGeneratorEntityFilterAction();
        filterAction.setClient(this.client);
        filterAction.setNameFilter((NameFilter)NamePatternMatcher.build((Log)logger, (String)this.includeEntitiesPattern, (String)this.excludeEntitiesPattern));
        try {
            DataMap dataMap = loadAction.getMainDataMap();
            ClassGenerationAction generatorAction = this.createGeneratorAction();
            generatorAction.setLogger(logger);
            generatorAction.setTimestamp(this.map.lastModified());
            generatorAction.setDataMap(dataMap);
            generatorAction.addEntities(filterAction.getFilteredEntities(dataMap));
            generatorAction.addEmbeddables(filterAction.getFilteredEmbeddables(dataMap));
            generatorAction.addQueries(dataMap.getQueries());
            generatorAction.execute();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.map == null && this.getProject() == null) {
            throw new BuildException("either 'map' or 'project' is required.");
        }
    }

    @Override
    public void setMap(File map) {
        this.map = map;
    }

    public void setAdditionalMaps(Path additionalMapsPath) {
        String[] additionalMapFilenames = additionalMapsPath.list();
        this.additionalMaps = new File[additionalMapFilenames.length];
        for (int i = 0; i < additionalMapFilenames.length; ++i) {
            this.additionalMaps[i] = new File(additionalMapFilenames[i]);
        }
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setMakepairs(boolean makepairs) {
        this.makepairs = makepairs;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setSupertemplate(String supertemplate) {
        this.supertemplate = supertemplate;
    }

    public void setQueryTemplate(String querytemplate) {
        this.querytemplate = querytemplate;
    }

    public void setQuerySupertemplate(String querysupertemplate) {
        this.querysupertemplate = querysupertemplate;
    }

    public void setUsepkgpath(boolean usepkgpath) {
        this.usepkgpath = usepkgpath;
    }

    public void setSuperpkg(String superpkg) {
        this.superpkg = superpkg;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExcludeEntities(String excludeEntitiesPattern) {
        this.excludeEntitiesPattern = excludeEntitiesPattern;
    }

    public void setIncludeEntities(String includeEntitiesPattern) {
        this.includeEntitiesPattern = includeEntitiesPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setEmbeddabletemplate(String embeddabletemplate) {
        this.embeddabletemplate = embeddabletemplate;
    }

    public void setEmbeddablesupertemplate(String embeddablesupertemplate) {
        this.embeddablesupertemplate = embeddablesupertemplate;
    }

    public Object createConfig() {
        this.vppConfig = new VPPConfig();
        return this.vppConfig;
    }

    private void initializeVppConfig() {
        if (this.vppConfig == null) {
            this.vppConfig = VPPConfig.getDefaultConfig((Project)this.getProject());
        }
    }
}

