/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.naming.ObjectNameGenerator;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.AddRelationshipToDb;
import org.apache.cayenne.merge.DbMerger;
import org.apache.cayenne.merge.ExecutingMergerContext;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.ModelMergeDelegate;
import org.apache.cayenne.merge.ProxyModelMergeDelegate;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectSaver;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.tools.dbimport.DbImportConfiguration;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;

public class DbImportAction {
    private final ProjectSaver projectSaver;
    private final Log logger;
    private final DataSourceFactory dataSourceFactory;
    private final DbAdapterFactory adapterFactory;
    private final MapLoader mapLoader;

    public DbImportAction(@Inject Log logger, @Inject ProjectSaver projectSaver, @Inject DataSourceFactory dataSourceFactory, @Inject DbAdapterFactory adapterFactory, @Inject MapLoader mapLoader) {
        this.logger = logger;
        this.projectSaver = projectSaver;
        this.dataSourceFactory = dataSourceFactory;
        this.adapterFactory = adapterFactory;
        this.mapLoader = mapLoader;
    }

    public void execute(DbImportConfiguration config) throws Exception {
        DataSource dataSource;
        DataNodeDescriptor dataNodeDescriptor;
        DbAdapter adapter;
        DataMap loadedFomDb;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DB connection: " + config.getDataSourceInfo()));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)config);
        }
        if ((loadedFomDb = this.load(config, adapter = this.adapterFactory.createAdapter(dataNodeDescriptor = config.createDataNodeDescriptor(), dataSource = this.dataSourceFactory.getDataSource(dataNodeDescriptor)), dataSource.getConnection())) == null) {
            this.logger.info((Object)"Nothing was loaded from db.");
            return;
        }
        DataMap existing = this.loadExistingDataMap(config.getDataMapFile());
        if (existing == null) {
            this.logger.info((Object)"");
            File file = config.getDataMapFile();
            this.logger.info((Object)("Map file does not exist. Loaded db model will be saved into '" + (file == null ? "null" : file.getAbsolutePath() + "'")));
            this.saveLoaded(config.initializeDataMap(loadedFomDb));
        } else {
            MergerFactory mergerFactory = adapter.mergerFactory();
            List mergeTokens = new DbMerger(mergerFactory).createMergeTokens(existing, loadedFomDb, config.getDbLoaderConfig());
            if (mergeTokens.isEmpty()) {
                this.logger.info((Object)"");
                this.logger.info((Object)"Detected changes: No changes to import.");
                return;
            }
            if (!StringUtils.isBlank((String)config.getDefaultPackage())) {
                existing.setDefaultPackage(config.getDefaultPackage());
            }
            final LinkedList loadedObjEntities = new LinkedList();
            DataMap executed = this.execute((ModelMergeDelegate)new ProxyModelMergeDelegate(config.createMergeDelegate()){

                public void objEntityAdded(ObjEntity ent) {
                    loadedObjEntities.add(ent);
                    super.objEntityAdded(ent);
                }
            }, existing, this.log(DbImportAction.sort(this.reverse(mergerFactory, mergeTokens))));
            DbLoader.flattenManyToManyRelationships((DataMap)executed, loadedObjEntities, (ObjectNameGenerator)config.getNameGenerator());
            this.relationshipsSanity(executed);
            this.saveLoaded(executed);
        }
    }

    private void relationshipsSanity(DataMap executed) {
        for (ObjEntity objEntity : executed.getObjEntities()) {
            for (ObjRelationship objRelationship : objEntity.getRelationships()) {
                if (objRelationship.getSourceEntity() != null && objRelationship.getTargetEntity() != null) continue;
                this.logger.error((Object)("Incorrect obj relationship: " + objRelationship));
                objEntity.removeRelationship(objRelationship.getName());
            }
        }
    }

    protected static List<MergerToken> sort(List<MergerToken> reverse) {
        Collections.sort(reverse, new Comparator<MergerToken>(){

            @Override
            public int compare(MergerToken o1, MergerToken o2) {
                if (o1 instanceof AddRelationshipToDb && o2 instanceof AddRelationshipToDb) {
                    return 0;
                }
                if (!(o1 instanceof AddRelationshipToDb) && !(o2 instanceof AddRelationshipToDb)) {
                    return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
                }
                return o1 instanceof AddRelationshipToDb ? 1 : -1;
            }
        });
        return reverse;
    }

    private Collection<MergerToken> log(List<MergerToken> tokens) {
        this.logger.info((Object)"");
        if (tokens.isEmpty()) {
            this.logger.info((Object)"Detected changes: No changes to import.");
            return tokens;
        }
        this.logger.info((Object)"Detected changes: ");
        for (MergerToken token : tokens) {
            this.logger.info((Object)String.format("    %-20s %s", token.getTokenName(), token.getTokenValue()));
        }
        this.logger.info((Object)"");
        return tokens;
    }

    private DataMap loadExistingDataMap(File dataMapFile) throws IOException {
        if (dataMapFile != null && dataMapFile.exists() && dataMapFile.canRead()) {
            DataMap dataMap = this.mapLoader.loadDataMap(new InputSource(dataMapFile.getCanonicalPath()));
            dataMap.setNamespace((MappingNamespace)new EntityResolver(Collections.singleton(dataMap)));
            dataMap.setConfigurationSource((Resource)new URLResource(dataMapFile.toURI().toURL()));
            return dataMap;
        }
        return null;
    }

    private List<MergerToken> reverse(MergerFactory mergerFactory, Iterable<MergerToken> mergeTokens) throws IOException {
        LinkedList<MergerToken> tokens = new LinkedList<MergerToken>();
        for (MergerToken token : mergeTokens) {
            if (token instanceof AbstractToModelToken) continue;
            tokens.add(token.createReverse(mergerFactory));
        }
        return tokens;
    }

    private DataMap execute(ModelMergeDelegate mergeDelegate, DataMap dataMap, Collection<MergerToken> tokens) {
        ExecutingMergerContext mergerContext = new ExecutingMergerContext(dataMap, null, null, mergeDelegate);
        for (MergerToken tok : tokens) {
            try {
                tok.execute((MergerContext)mergerContext);
            }
            catch (Throwable th) {
                String message = "Migration Error. Can't apply changes from token: " + tok.getTokenName() + " (" + tok.getTokenValue() + ")";
                this.logger.error((Object)message, th);
                mergerContext.getValidationResult().addFailure((ValidationFailure)new SimpleValidationFailure((Object)th, (Object)message));
            }
        }
        ValidationResult failures = mergerContext.getValidationResult();
        if (failures == null || !failures.hasFailures()) {
            this.logger.info((Object)"Migration Complete Successfully.");
        } else {
            this.logger.info((Object)"Migration Complete.");
            this.logger.warn((Object)"Migration finished. The following problem(s) were ignored.");
            for (ValidationFailure failure : failures.getFailures()) {
                this.logger.warn((Object)failure.toString());
            }
        }
        return dataMap;
    }

    private DbLoader getLoader(DbImportConfiguration config, DbAdapter adapter, Connection connection) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return config.createLoader(adapter, connection, config.createLoaderDelegate());
    }

    void saveLoaded(DataMap dataMap) throws FileNotFoundException {
        ConfigurationTree projectRoot = new ConfigurationTree((ConfigurationNode)dataMap);
        Project project = new Project(projectRoot);
        this.projectSaver.save(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataMap load(DbImportConfiguration config, DbAdapter adapter, Connection connection) throws Exception {
        DataMap dataMap = config.createDataMap();
        try {
            DbLoader loader = config.createLoader(adapter, connection, config.createLoaderDelegate());
            loader.load(dataMap, config.getDbLoaderConfig());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return dataMap;
    }
}

