/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.access.loader.DbLoaderConfiguration;
import org.apache.cayenne.access.loader.DefaultDbLoaderDelegate;
import org.apache.cayenne.access.loader.LoggingDbLoaderDelegate;
import org.apache.cayenne.access.loader.NameFilter;
import org.apache.cayenne.access.loader.NamePatternMatcher;
import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.FiltersConfig;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.naming.LegacyNameGenerator;
import org.apache.cayenne.map.naming.ObjectNameGenerator;
import org.apache.cayenne.merge.DbMergerConfig;
import org.apache.cayenne.merge.DefaultModelMergeDelegate;
import org.apache.cayenne.merge.ModelMergeDelegate;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.util.EntityMergeSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class DbImportConfiguration {
    private static final String DATA_MAP_LOCATION_SUFFIX = ".map.xml";
    private File dataMapFile;
    private String defaultPackage;
    private boolean overwrite;
    private String meaningfulPkTables;
    private String adapter;
    private boolean usePrimitives;
    private Log logger;
    private final DataSourceInfo dataSourceInfo = new DataSourceInfo();
    private final DbLoaderConfiguration dbLoaderConfiguration = new DbLoaderConfiguration();

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public File getDataMapFile() {
        return this.dataMapFile;
    }

    public void setDataMapFile(File map) {
        this.dataMapFile = map;
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getNamingStrategy() {
        return this.dbLoaderConfiguration.getNamingStrategy();
    }

    public void setNamingStrategy(String namingStrategy) {
        this.dbLoaderConfiguration.setNamingStrategy(namingStrategy);
    }

    public String getAdapter() {
        return this.adapter;
    }

    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    public String getMeaningfulPkTables() {
        return this.meaningfulPkTables;
    }

    public void setMeaningfulPkTables(String meaningfulPkTables) {
        this.meaningfulPkTables = meaningfulPkTables;
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }

    public DbLoader createLoader(DbAdapter adapter, Connection connection, DbLoaderDelegate loaderDelegate) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        NamePatternMatcher meaningfulPkFilter = NamePatternMatcher.build((Log)this.logger, (String)this.getMeaningfulPkTables(), (String)(this.getMeaningfulPkTables() != null ? null : "*"));
        DbLoader loader = new DbLoader(connection, adapter, loaderDelegate, (NameFilter)meaningfulPkFilter){
            final /* synthetic */ NameFilter val$meaningfulPkFilter;
            {
                this.val$meaningfulPkFilter = nameFilter;
                super(x0, x1, x2);
            }

            protected EntityMergeSupport createEntityMerger(DataMap map) {
                EntityMergeSupport emSupport = new EntityMergeSupport(map, this.getNameGenerator(), true){

                    protected boolean removePK(DbEntity dbEntity) {
                        return !val$meaningfulPkFilter.isIncluded(dbEntity.getName());
                    }
                };
                emSupport.setUsePrimitives(DbImportConfiguration.this.isUsePrimitives());
                return emSupport;
            }
        };
        loader.setNameGenerator(this.getNameGenerator());
        return loader;
    }

    public ObjectNameGenerator getNameGenerator() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String namingStrategy = this.getNamingStrategy();
        if (namingStrategy != null) {
            return (ObjectNameGenerator)Class.forName(namingStrategy).newInstance();
        }
        return new LegacyNameGenerator();
    }

    public void setDriver(String jdbcDriver) {
        this.dataSourceInfo.setJdbcDriver(jdbcDriver);
    }

    public String getDriver() {
        return this.dataSourceInfo.getJdbcDriver();
    }

    public void setPassword(String password) {
        this.dataSourceInfo.setPassword(password);
    }

    public String getPassword() {
        return this.dataSourceInfo.getPassword();
    }

    public void setUsername(String userName) {
        this.dataSourceInfo.setUserName(userName);
    }

    public String getUsername() {
        return this.dataSourceInfo.getUserName();
    }

    public void setUrl(String dataSourceUrl) {
        this.dataSourceInfo.setDataSourceUrl(dataSourceUrl);
    }

    public String getUrl() {
        return this.dataSourceInfo.getDataSourceUrl();
    }

    public DataNodeDescriptor createDataNodeDescriptor() {
        DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
        nodeDescriptor.setAdapterType(this.getAdapter());
        nodeDescriptor.setDataSourceDescriptor(this.dataSourceInfo);
        return nodeDescriptor;
    }

    public DataMap createDataMap() throws IOException {
        if (this.dataMapFile == null) {
            throw new NullPointerException("Null DataMap File.");
        }
        return this.initializeDataMap(new DataMap());
    }

    public DataMap initializeDataMap(DataMap dataMap) throws MalformedURLException {
        List dbPaths;
        dataMap.setName(this.getDataMapName());
        dataMap.setConfigurationSource((Resource)new URLResource(this.dataMapFile.toURI().toURL()));
        dataMap.setNamespace((MappingNamespace)new EntityResolver(Collections.singleton(dataMap)));
        String defaultPackage = this.getDefaultPackage();
        if (StringUtils.isNotEmpty((String)defaultPackage)) {
            dataMap.setDefaultPackage(defaultPackage);
        }
        if (!(dbPaths = this.dbLoaderConfiguration.getFiltersConfig().getDbPaths()).isEmpty()) {
            String schema;
            String catalog = ((DbPath)dbPaths.get((int)0)).catalog;
            if (StringUtils.isNotEmpty((String)catalog) && catalog.indexOf(37) < 0) {
                dataMap.setDefaultCatalog(catalog);
            }
            if (StringUtils.isNotEmpty((String)(schema = ((DbPath)dbPaths.get((int)0)).schema)) && schema.indexOf(37) < 0) {
                dataMap.setDefaultSchema(schema);
            }
        }
        return dataMap;
    }

    public String getDataMapName() {
        String name = this.dataMapFile.getName();
        if (!name.endsWith(DATA_MAP_LOCATION_SUFFIX)) {
            throw new CayenneRuntimeException("DataMap file name must end with '%s': '%s'", new Object[]{DATA_MAP_LOCATION_SUFFIX, name});
        }
        return name.substring(0, name.length() - DATA_MAP_LOCATION_SUFFIX.length());
    }

    public ModelMergeDelegate createMergeDelegate() {
        return new DefaultModelMergeDelegate();
    }

    public DbLoaderDelegate createLoaderDelegate() {
        if (this.getLogger() != null) {
            return new LoggingDbLoaderDelegate(this.getLogger());
        }
        return new DefaultDbLoaderDelegate();
    }

    public DbLoaderConfiguration getDbLoaderConfig() {
        return this.dbLoaderConfiguration;
    }

    public void setFiltersConfig(FiltersConfig filtersConfig) {
        this.dbLoaderConfiguration.setFiltersConfig(filtersConfig);
    }

    public String toString() {
        StringBuilder res = new StringBuilder("Importer options:");
        for (String line : this.dbLoaderConfiguration.toString().split("\n")) {
            res.append("    ").append(line).append("\n");
        }
        return res.toString();
    }

    public DataSourceInfo getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    public void setSkipRelationshipsLoading(Boolean skipRelationshipsLoading) {
        this.dbLoaderConfiguration.setSkipRelationshipsLoading(skipRelationshipsLoading);
    }

    public void setSkipPrimaryKeyLoading(Boolean skipPrimaryKeyLoading) {
        this.dbLoaderConfiguration.setSkipPrimaryKeyLoading(skipPrimaryKeyLoading);
    }

    public void setTableTypes(String[] tableTypes) {
        this.dbLoaderConfiguration.setTableTypes(tableTypes);
    }

    public DbMergerConfig getDbMergerConfig() {
        return new DbMergerConfig(this.getDbLoaderConfig().getFiltersConfig(), this.getDbLoaderConfig().getSkipRelationshipsLoading().booleanValue(), this.getDbLoaderConfig().getSkipPrimaryKeyLoading());
    }
}

