/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport.config;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.tools.ExcludeTable;
import org.apache.cayenne.tools.dbimport.config.ExcludeColumn;
import org.apache.cayenne.tools.dbimport.config.ExcludeProcedure;
import org.apache.cayenne.tools.dbimport.config.IncludeColumn;
import org.apache.cayenne.tools.dbimport.config.IncludeProcedure;
import org.apache.cayenne.tools.dbimport.config.IncludeTable;
import org.apache.cayenne.tools.dbimport.config.PatternParam;

public abstract class FilterContainer {
    private Collection<IncludeTable> includeTables = new LinkedList<IncludeTable>();
    private Collection<ExcludeTable> excludeTables = new LinkedList<ExcludeTable>();
    private Collection<IncludeColumn> includeColumns = new LinkedList<IncludeColumn>();
    private Collection<ExcludeColumn> excludeColumns = new LinkedList<ExcludeColumn>();
    private Collection<IncludeProcedure> includeProcedures = new LinkedList<IncludeProcedure>();
    private Collection<ExcludeProcedure> excludeProcedures = new LinkedList<ExcludeProcedure>();

    public Collection<IncludeTable> getIncludeTables() {
        return this.includeTables;
    }

    public void setIncludeTables(Collection<IncludeTable> includeTables) {
        this.includeTables = includeTables;
    }

    public Collection<ExcludeTable> getExcludeTables() {
        return this.excludeTables;
    }

    public void setExcludeTables(Collection<ExcludeTable> excludeTables) {
        this.excludeTables = excludeTables;
    }

    public Collection<IncludeColumn> getIncludeColumns() {
        return this.includeColumns;
    }

    public void setIncludeColumns(Collection<IncludeColumn> includeColumns) {
        this.includeColumns = includeColumns;
    }

    public Collection<ExcludeColumn> getExcludeColumns() {
        return this.excludeColumns;
    }

    public void setExcludeColumns(Collection<ExcludeColumn> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public Collection<IncludeProcedure> getIncludeProcedures() {
        return this.includeProcedures;
    }

    public void setIncludeProcedures(Collection<IncludeProcedure> includeProcedures) {
        this.includeProcedures = includeProcedures;
    }

    public Collection<ExcludeProcedure> getExcludeProcedures() {
        return this.excludeProcedures;
    }

    public void setExcludeProcedures(Collection<ExcludeProcedure> excludeProcedures) {
        this.excludeProcedures = excludeProcedures;
    }

    public void addIncludeColumn(IncludeColumn includeColumn) {
        this.includeColumns.add(includeColumn);
    }

    public void addExcludeColumn(ExcludeColumn excludeColumn) {
        this.excludeColumns.add(excludeColumn);
    }

    public void addIncludeTable(IncludeTable includeTable) {
        this.includeTables.add(includeTable);
    }

    public void addExcludeTable(ExcludeTable excludeTable) {
        this.excludeTables.add(excludeTable);
    }

    public void addIncludeProcedure(IncludeProcedure includeProcedure) {
        this.includeProcedures.add(includeProcedure);
    }

    public void addExcludeProcedure(ExcludeProcedure excludeProcedure) {
        this.excludeProcedures.add(excludeProcedure);
    }

    public boolean isEmptyContainer() {
        return this.includeColumns.isEmpty() && this.excludeColumns.isEmpty() && this.includeTables.isEmpty() && this.excludeTables.isEmpty() && this.includeProcedures.isEmpty() && this.excludeProcedures.isEmpty();
    }

    public String toString() {
        return this.toString("    ");
    }

    public String toString(String indent) {
        return this.toStringFilters(indent + "Filter Tables     - ", this.includeTables, this.excludeTables) + this.toStringFilters(indent + "Filter Columns    - ", this.includeColumns, this.excludeColumns) + this.toStringFilters(indent + "Filter Procedures - ", this.includeProcedures, this.excludeProcedures);
    }

    private String toStringFilters(String name, Collection<? extends PatternParam> include, Collection<? extends PatternParam> exclude) {
        if (include.isEmpty() && exclude.isEmpty()) {
            return "";
        }
        String res = "\n" + name + ": ";
        if (!include.isEmpty()) {
            res = res + include + " ";
        }
        if (!exclude.isEmpty()) {
            res = res + exclude + " ";
        }
        return res;
    }
}

