/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport.config;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.EntityFilters;
import org.apache.cayenne.access.loader.filters.Filter;
import org.apache.cayenne.access.loader.filters.FilterFactory;
import org.apache.cayenne.access.loader.filters.FiltersConfig;
import org.apache.cayenne.access.loader.filters.ListFilter;
import org.apache.cayenne.tools.dbimport.config.Catalog;
import org.apache.cayenne.tools.dbimport.config.FilterContainer;
import org.apache.cayenne.tools.dbimport.config.IncludeTable;
import org.apache.cayenne.tools.dbimport.config.PatternParam;
import org.apache.cayenne.tools.dbimport.config.ReverseEngineering;
import org.apache.cayenne.tools.dbimport.config.Schema;

public final class FiltersConfigBuilder {
    private final ReverseEngineering engineering;
    private final List<EntityFilters> filters = new LinkedList<EntityFilters>();

    public FiltersConfigBuilder(ReverseEngineering engineering) {
        this.engineering = engineering;
    }

    public FiltersConfigBuilder add(EntityFilters filter) {
        if (filter.isDefault()) {
            return this;
        }
        if (!filter.isEmpty()) {
            this.filters.add(filter);
        } else if (!filter.getDbPath().equals((Object)new DbPath())) {
            this.filters.add(this.defaultFilter(filter.getDbPath()));
        }
        return this;
    }

    public FiltersConfig filtersConfig() {
        DbPath path = new DbPath();
        this.filters.addAll(this.processFilters(path, this.engineering));
        this.filters.addAll(this.processSchemas(path, this.engineering.getSchemas()));
        this.filters.addAll(this.processCatalog(path, this.engineering.getCatalogs()));
        if (this.filters.isEmpty()) {
            this.filters.add(this.defaultFilter(path));
        }
        return new FiltersConfig(this.filters);
    }

    private EntityFilters defaultFilter(DbPath path) {
        return new EntityFilters(path, FilterFactory.TRUE, FilterFactory.TRUE, FilterFactory.NULL);
    }

    private Collection<? extends EntityFilters> processSchemas(DbPath root, Collection<Schema> schemas) {
        LinkedList<EntityFilters> filters = new LinkedList<EntityFilters>();
        for (Schema schema : schemas) {
            DbPath path = new DbPath(root.catalog, schema.getName());
            List<EntityFilters> schemaFilters = this.processFilters(path, schema);
            if (schemaFilters.isEmpty()) {
                schemaFilters.add(this.defaultFilter(path));
            }
            filters.addAll(schemaFilters);
        }
        return filters;
    }

    private Collection<? extends EntityFilters> processCatalog(DbPath root, Collection<Catalog> catalogs) {
        LinkedList filters = new LinkedList();
        for (Catalog catalog : catalogs) {
            DbPath path = new DbPath(catalog.getName());
            LinkedList<Object> catalogFilters = new LinkedList<Object>();
            catalogFilters.addAll(this.processFilters(path, catalog));
            catalogFilters.addAll(this.processSchemas(path, catalog.getSchemas()));
            if (catalogFilters.isEmpty()) {
                catalogFilters.add(this.defaultFilter(path));
            }
            filters.addAll(catalogFilters);
        }
        return filters;
    }

    private List<EntityFilters> processFilters(DbPath root, FilterContainer container) {
        LinkedList<EntityFilters> res = new LinkedList<EntityFilters>();
        res.addAll(this.processTableFilters(root, container.getIncludeTables()));
        EntityFilters filter = new EntityFilters(root, this.processIncludes(container.getIncludeTables()).join(this.processExcludes(container.getExcludeTables())), this.processIncludes(container.getIncludeColumns()).join(this.processExcludes(container.getExcludeColumns())), this.processIncludes(container.getIncludeProcedures()).join(this.processExcludes(container.getExcludeProcedures())));
        if (!filter.isEmpty()) {
            res.add(filter);
        }
        return res;
    }

    private List<EntityFilters> processTableFilters(DbPath root, Collection<IncludeTable> tables) {
        LinkedList<EntityFilters> list = new LinkedList<EntityFilters>();
        for (IncludeTable includeTable : tables) {
            Filter filter = FilterFactory.TRUE.join(this.processIncludes(includeTable.getIncludeColumns())).join(this.processExcludes(includeTable.getExcludeColumns()));
            DbPath dbPath = new DbPath(root.catalog, root.schema, includeTable.getPattern());
            list.add(new EntityFilters(dbPath, FilterFactory.NULL, filter, FilterFactory.NULL));
        }
        return list;
    }

    private Filter<String> processIncludes(Collection<? extends PatternParam> filters) {
        return this.processFilters("include", filters);
    }

    private Filter<String> processExcludes(Collection<? extends PatternParam> excludeProcedures) {
        return this.processFilters("exclude", excludeProcedures);
    }

    private Filter<String> processFilters(String factoryMethodName, Collection<? extends PatternParam> includeProcedures) {
        Method factoryMethod;
        try {
            factoryMethod = FilterFactory.class.getMethod(factoryMethodName, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        LinkedList<Filter> filters = new LinkedList<Filter>();
        for (PatternParam patternParam : includeProcedures) {
            try {
                filters.add((Filter)factoryMethod.invoke(FilterFactory.class, patternParam.getPattern()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (filters.isEmpty()) {
            return FilterFactory.NULL;
        }
        return new ListFilter(filters);
    }
}

