/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport.config;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.tools.dbimport.config.Catalog;
import org.apache.cayenne.tools.dbimport.config.FilterContainer;
import org.apache.cayenne.tools.dbimport.config.Schema;

public class ReverseEngineering
extends FilterContainer {
    private Boolean skipRelationshipsLoading;
    private Boolean skipPrimaryKeyLoading;
    private Collection<String> tableTypes = new LinkedList<String>();
    private Collection<Catalog> catalogs = new LinkedList<Catalog>();
    private Collection<Schema> schemas = new LinkedList<Schema>();

    public Boolean getSkipRelationshipsLoading() {
        return this.skipRelationshipsLoading;
    }

    public void setSkipRelationshipsLoading(Boolean skipRelationshipsLoading) {
        this.skipRelationshipsLoading = skipRelationshipsLoading;
    }

    public Boolean getSkipPrimaryKeyLoading() {
        return this.skipPrimaryKeyLoading;
    }

    public void setSkipPrimaryKeyLoading(Boolean skipPrimaryKeyLoading) {
        this.skipPrimaryKeyLoading = skipPrimaryKeyLoading;
    }

    public Collection<Catalog> getCatalogs() {
        return this.catalogs;
    }

    public void setCatalogs(Collection<Catalog> catalogs) {
        this.catalogs = catalogs;
    }

    public Collection<Schema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Collection<Schema> schemas) {
        this.schemas = schemas;
    }

    public String[] getTableTypes() {
        return this.tableTypes.toArray(new String[this.tableTypes.size()]);
    }

    public void setTableTypes(Collection<String> tableTypes) {
        this.tableTypes = tableTypes;
    }

    public void addTableType(String type) {
        this.tableTypes.add(type);
    }

    public void addSchema(Schema schema) {
        this.schemas.add(schema);
    }

    public void addCatalog(Catalog catalog) {
        this.catalogs.add(catalog);
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder("    ReverseEngineering: ");
        for (Catalog catalog : this.catalogs) {
            res.append("\n").append(catalog.toString("        "));
        }
        for (Schema schema : this.schemas) {
            res.append("\n").append(schema.toString("        "));
        }
        if (this.skipRelationshipsLoading != null && this.skipRelationshipsLoading.booleanValue()) {
            res.append("\n").append("        Skip Relationships Loading");
        }
        if (this.skipPrimaryKeyLoading != null && this.skipPrimaryKeyLoading.booleanValue()) {
            res.append("\n").append("        Skip PrimaryKey Loading");
        }
        res.append(super.toString("    "));
        return res.toString();
    }
}

