/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataMapListener;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.configuration.event.DataNodeListener;
import org.apache.cayenne.configuration.event.DomainEvent;
import org.apache.cayenne.configuration.event.DomainListener;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.configuration.event.ProcedureListener;
import org.apache.cayenne.configuration.event.ProcedureParameterEvent;
import org.apache.cayenne.configuration.event.ProcedureParameterListener;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.configuration.event.QueryListener;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DbRelationshipListener;
import org.apache.cayenne.map.event.EmbeddableAttributeEvent;
import org.apache.cayenne.map.event.EmbeddableAttributeListener;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EmbeddableListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.map.event.ObjRelationshipListener;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectFileChangeTracker;
import org.apache.cayenne.modeler.action.NavigateBackwardAction;
import org.apache.cayenne.modeler.action.NavigateForwardAction;
import org.apache.cayenne.modeler.action.RevertAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.action.SaveAsAction;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.editor.ObjCallbackMethod;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.event.CallbackMethodListener;
import org.apache.cayenne.modeler.event.DataMapDisplayEvent;
import org.apache.cayenne.modeler.event.DataMapDisplayListener;
import org.apache.cayenne.modeler.event.DataNodeDisplayEvent;
import org.apache.cayenne.modeler.event.DataNodeDisplayListener;
import org.apache.cayenne.modeler.event.DbAttributeDisplayListener;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.DbRelationshipDisplayListener;
import org.apache.cayenne.modeler.event.DisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.modeler.event.DomainDisplayListener;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayListener;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.EntityListenerEvent;
import org.apache.cayenne.modeler.event.EntityListenerListener;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayEvent;
import org.apache.cayenne.modeler.event.MultipleObjectsDisplayListener;
import org.apache.cayenne.modeler.event.ObjAttributeDisplayListener;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ObjRelationshipDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayListener;
import org.apache.cayenne.modeler.event.ProjectOnSaveEvent;
import org.apache.cayenne.modeler.event.ProjectOnSaveListener;
import org.apache.cayenne.modeler.event.QueryDisplayEvent;
import org.apache.cayenne.modeler.event.QueryDisplayListener;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.pref.DataNodeDefaults;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.CircularArray;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.project.ConfigurationNodeParentGetter;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.IDUtil;

public class ProjectController
extends CayenneController {
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean dirty;
    protected int entityTabSelection;
    protected Project project;
    protected Preferences projectControllerPreferences;
    protected ControllerState currentState;
    protected CircularArray controllerStateHistory = new CircularArray(this.maxHistorySize);
    protected int maxHistorySize = 20;
    private EntityResolver entityResolver;
    private ProjectFileChangeTracker fileChangeTracker;

    public ProjectController(CayenneModelerController parent) {
        super(parent);
        this.currentState = new ControllerState();
    }

    @Override
    public Component getView() {
        return this.parent.getView();
    }

    public Project getProject() {
        return this.project;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setProject(Project currentProject) {
        if (this.project != currentProject) {
            this.project = currentProject;
            this.projectControllerPreferences = null;
            if (this.project == null) {
                this.entityResolver = null;
                if (this.fileChangeTracker != null) {
                    this.fileChangeTracker.interrupt();
                    this.fileChangeTracker = null;
                }
            } else {
                if (this.fileChangeTracker == null) {
                    this.fileChangeTracker = new ProjectFileChangeTracker(this);
                    this.fileChangeTracker.setDaemon(true);
                    this.fileChangeTracker.start();
                }
                this.fileChangeTracker.reconfigure();
                this.entityResolver = new EntityResolver(((DataChannelDescriptor)currentProject.getRootNode()).getDataMaps());
                this.updateEntityResolver();
            }
        }
    }

    public void updateEntityResolver() {
        Collection dataMaps = ((DataChannelDescriptor)this.project.getRootNode()).getDataMaps();
        this.entityResolver.setDataMaps(dataMaps);
        for (DataMap dataMap : dataMaps) {
            dataMap.setNamespace((MappingNamespace)this.entityResolver);
        }
    }

    public Preferences getPreferenceForProject() {
        if (this.getProject() == null) {
            throw new CayenneRuntimeException("No Project selected", new Object[0]);
        }
        if (this.projectControllerPreferences == null) {
            this.updateProjectControllerPreferences();
        }
        return this.projectControllerPreferences;
    }

    public Preferences getPreferenceForDataDomain() {
        DataChannelDescriptor dataDomain = (DataChannelDescriptor)this.getProject().getRootNode();
        if (dataDomain == null) {
            throw new CayenneRuntimeException("No DataDomain selected", new Object[0]);
        }
        return this.getPreferenceForProject().node(dataDomain.getName());
    }

    public DataMapDefaults getDataMapPreferences(String nameSuffix) {
        DataMap map = this.getCurrentDataMap();
        if (map == null) {
            throw new CayenneRuntimeException("No DataMap selected", new Object[0]);
        }
        Preferences pref = nameSuffix == null || nameSuffix.length() == 0 ? this.getPreferenceForDataDomain().node("DataMap").node(map.getName()) : this.getPreferenceForDataDomain().node("DataMap").node(map.getName()).node(nameSuffix);
        return (DataMapDefaults)this.application.getCayenneProjectPreferences().getProjectDetailObject(DataMapDefaults.class, pref);
    }

    public DataMapDefaults getDataMapPreferences(DataMap dataMap) {
        Preferences pref = this.getPreferenceForDataDomain().node("DataMap").node(dataMap.getName());
        return (DataMapDefaults)this.application.getCayenneProjectPreferences().getProjectDetailObject(DataMapDefaults.class, pref);
    }

    public DataMapDefaults getDataMapPreferences(String nameSuffix, DataMap map) {
        Preferences pref = nameSuffix == null || nameSuffix.length() == 0 ? this.getPreferenceForDataDomain().node("DataMap").node(map.getName()) : this.getPreferenceForDataDomain().node("DataMap").node(map.getName()).node(nameSuffix);
        return (DataMapDefaults)this.application.getCayenneProjectPreferences().getProjectDetailObject(DataMapDefaults.class, pref);
    }

    public DataNodeDefaults getDataNodePreferences() {
        DataNodeDescriptor node = this.getCurrentDataNode();
        if (node == null) {
            throw new CayenneRuntimeException("No DataNode selected", new Object[0]);
        }
        return (DataNodeDefaults)this.application.getCayenneProjectPreferences().getProjectDetailObject(DataNodeDefaults.class, this.getPreferenceForDataDomain().node("DataNode").node(node.getName()));
    }

    public void projectOpened() {
        CayenneModelerFrame frame = (CayenneModelerFrame)this.getView();
        this.addDataNodeDisplayListener(frame);
        this.addDataMapDisplayListener(frame);
        this.addObjEntityDisplayListener(frame);
        this.addDbEntityDisplayListener(frame);
        this.addQueryDisplayListener(frame);
        this.addProcedureDisplayListener(frame);
        this.addMultipleObjectsDisplayListener(frame);
        this.addEmbeddableDisplayListener(frame);
    }

    public void reset() {
        this.clearState();
        this.setDirty(false);
        this.setEntityTabSelection(0);
        this.listenerList = new EventListenerList();
        this.controllerStateHistory.clear();
    }

    public void setHistorySize(int newSize) {
        this.controllerStateHistory.resize(newSize);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void clearState() {
        if (this.currentState.isRefiring) {
            return;
        }
        this.currentState = new ControllerState();
    }

    private void saveState(DisplayEvent e) {
        if (!this.controllerStateHistory.contains(this.currentState)) {
            this.currentState.event = e;
            this.controllerStateHistory.add(this.currentState);
        }
    }

    private void removeFromHistory(EventObject e) {
        int count = this.controllerStateHistory.size();
        ArrayList<ControllerState> removeList = new ArrayList<ControllerState>();
        for (int i = 0; i < count; ++i) {
            ControllerState controllerState = (ControllerState)this.controllerStateHistory.get(i);
            DisplayEvent csEvent = controllerState.event;
            if (csEvent == null) continue;
            if (e instanceof EntityEvent && csEvent instanceof EntityDisplayEvent) {
                if (((EntityEvent)e).getEntity() != ((EntityDisplayEvent)csEvent).getEntity()) continue;
                removeList.add(controllerState);
                continue;
            }
            if (e instanceof EmbeddableEvent && csEvent instanceof EmbeddableDisplayEvent) {
                if (((EmbeddableEvent)e).getEmbeddable() != ((EmbeddableDisplayEvent)csEvent).getEmbeddable()) continue;
                removeList.add(controllerState);
                continue;
            }
            if (e instanceof ProcedureEvent && csEvent instanceof ProcedureDisplayEvent) {
                if (((ProcedureEvent)((Object)e)).getProcedure() != ((ProcedureDisplayEvent)csEvent).getProcedure()) continue;
                removeList.add(controllerState);
                continue;
            }
            if (e instanceof QueryEvent && csEvent instanceof QueryDisplayEvent) {
                if (((QueryEvent)((Object)e)).getQuery() != ((QueryDisplayEvent)csEvent).getQuery()) continue;
                removeList.add(controllerState);
                continue;
            }
            if (e instanceof DataMapEvent && csEvent instanceof DataMapDisplayEvent) {
                if (((DataMapEvent)((Object)e)).getDataMap() != ((DataMapDisplayEvent)csEvent).getDataMap()) continue;
                removeList.add(controllerState);
                continue;
            }
            if (e instanceof DataNodeEvent && csEvent instanceof DataNodeDisplayEvent) {
                if (((DataNodeEvent)((Object)e)).getDataNode() != ((DataNodeDisplayEvent)csEvent).getDataNode()) continue;
                removeList.add(controllerState);
                continue;
            }
            if (!(e instanceof DomainEvent) || !(csEvent instanceof DomainDisplayEvent) || ((DomainEvent)((Object)e)).getDomain() != ((DomainDisplayEvent)csEvent).getDomain()) continue;
            removeList.add(controllerState);
        }
        for (Object e2 : removeList) {
            this.controllerStateHistory.remove(e2);
        }
    }

    public DataChannelDescriptor getCurrentDataChanel() {
        return this.currentState.domain;
    }

    public DataNodeDescriptor getCurrentDataNode() {
        return this.currentState.node;
    }

    public DataMap getCurrentDataMap() {
        return this.currentState.map;
    }

    public ObjEntity getCurrentObjEntity() {
        return this.currentState.objEntity;
    }

    public Embeddable getCurrentEmbeddable() {
        return this.currentState.embeddable;
    }

    public DbEntity getCurrentDbEntity() {
        return this.currentState.dbEntity;
    }

    public ObjAttribute[] getCurrentObjAttributes() {
        return this.currentState.objAttrs;
    }

    public DbAttribute[] getCurrentDbAttributes() {
        return this.currentState.dbAttrs;
    }

    public EmbeddableAttribute[] getCurrentEmbAttributes() {
        return this.currentState.embAttrs;
    }

    public ObjRelationship[] getCurrentObjRelationships() {
        return this.currentState.objRels;
    }

    public DbRelationship[] getCurrentDbRelationships() {
        return this.currentState.dbRels;
    }

    public Query getCurrentQuery() {
        return this.currentState.query;
    }

    public Procedure getCurrentProcedure() {
        return this.currentState.procedure;
    }

    public ProcedureParameter[] getCurrentProcedureParameters() {
        return this.currentState.procedureParameters;
    }

    public Object[] getCurrentPaths() {
        return this.currentState.paths;
    }

    public Object getCurrentParentPath() {
        return this.currentState.parentPath;
    }

    public void addDomainDisplayListener(DomainDisplayListener listener) {
        this.listenerList.add(DomainDisplayListener.class, listener);
    }

    public void addDomainListener(DomainListener listener) {
        this.listenerList.add(DomainListener.class, listener);
    }

    public void removeDomainListener(DomainListener listener) {
        this.listenerList.remove(DomainListener.class, listener);
    }

    public void addDataNodeDisplayListener(DataNodeDisplayListener listener) {
        this.listenerList.add(DataNodeDisplayListener.class, listener);
    }

    public void addDataNodeListener(DataNodeListener listener) {
        this.listenerList.add(DataNodeListener.class, listener);
    }

    public void addDataMapDisplayListener(DataMapDisplayListener listener) {
        this.listenerList.add(DataMapDisplayListener.class, listener);
    }

    public void addDataMapListener(DataMapListener listener) {
        this.listenerList.add(DataMapListener.class, listener);
    }

    public void removeDataMapListener(DataMapListener listener) {
        this.listenerList.remove(DataMapListener.class, listener);
    }

    public void addDbEntityListener(DbEntityListener listener) {
        this.listenerList.add(DbEntityListener.class, listener);
    }

    public void removeDbEntityListener(DbEntityListener listener) {
        this.listenerList.remove(DbEntityListener.class, listener);
    }

    public void addProjectOnSaveListener(ProjectOnSaveListener listener) {
        this.listenerList.add(ProjectOnSaveListener.class, listener);
    }

    public void removeProjectOnSaveListener(ProjectOnSaveListener listener) {
        this.listenerList.remove(ProjectOnSaveListener.class, listener);
    }

    public void addObjEntityListener(ObjEntityListener listener) {
        this.listenerList.add(ObjEntityListener.class, listener);
    }

    public void removeObjEntityListener(ObjEntityListener listener) {
        this.listenerList.remove(ObjEntityListener.class, listener);
    }

    public void addDbEntityDisplayListener(DbEntityDisplayListener listener) {
        this.listenerList.add(DbEntityDisplayListener.class, listener);
    }

    public void addObjEntityDisplayListener(ObjEntityDisplayListener listener) {
        this.listenerList.add(ObjEntityDisplayListener.class, listener);
    }

    public void addEmbeddableDisplayListener(EmbeddableDisplayListener listener) {
        this.listenerList.add(EmbeddableDisplayListener.class, listener);
    }

    public void addEmbeddableAttributeDisplayListener(EmbeddableAttributeDisplayListener listener) {
        this.listenerList.add(EmbeddableAttributeDisplayListener.class, listener);
    }

    public void addDbAttributeListener(DbAttributeListener listener) {
        this.listenerList.add(DbAttributeListener.class, listener);
    }

    public void removeDbAttributeListener(DbAttributeListener listener) {
        this.listenerList.remove(DbAttributeListener.class, listener);
    }

    public void addDbAttributeDisplayListener(DbAttributeDisplayListener listener) {
        this.listenerList.add(DbAttributeDisplayListener.class, listener);
    }

    public void addObjAttributeListener(ObjAttributeListener listener) {
        this.listenerList.add(ObjAttributeListener.class, listener);
    }

    public void removeObjAttributeListener(ObjAttributeListener listener) {
        this.listenerList.remove(ObjAttributeListener.class, listener);
    }

    public void addObjAttributeDisplayListener(ObjAttributeDisplayListener listener) {
        this.listenerList.add(ObjAttributeDisplayListener.class, listener);
    }

    public void addDbRelationshipListener(DbRelationshipListener listener) {
        this.listenerList.add(DbRelationshipListener.class, listener);
    }

    public void removeDbRelationshipListener(DbRelationshipListener listener) {
        this.listenerList.add(DbRelationshipListener.class, listener);
    }

    public void addDbRelationshipDisplayListener(DbRelationshipDisplayListener listener) {
        this.listenerList.add(DbRelationshipDisplayListener.class, listener);
    }

    public void addObjRelationshipListener(ObjRelationshipListener listener) {
        this.listenerList.add(ObjRelationshipListener.class, listener);
    }

    public void removeObjRelationshipListener(ObjRelationshipListener listener) {
        this.listenerList.remove(ObjRelationshipListener.class, listener);
    }

    public void addObjRelationshipDisplayListener(ObjRelationshipDisplayListener listener) {
        this.listenerList.add(ObjRelationshipDisplayListener.class, listener);
    }

    public void addQueryDisplayListener(QueryDisplayListener listener) {
        this.listenerList.add(QueryDisplayListener.class, listener);
    }

    public void addQueryListener(QueryListener listener) {
        this.listenerList.add(QueryListener.class, listener);
    }

    public void addProcedureDisplayListener(ProcedureDisplayListener listener) {
        this.listenerList.add(ProcedureDisplayListener.class, listener);
    }

    public void addProcedureListener(ProcedureListener listener) {
        this.listenerList.add(ProcedureListener.class, listener);
    }

    public void addProcedureParameterListener(ProcedureParameterListener listener) {
        this.listenerList.add(ProcedureParameterListener.class, listener);
    }

    public void addProcedureParameterDisplayListener(ProcedureParameterDisplayListener listener) {
        this.listenerList.add(ProcedureParameterDisplayListener.class, listener);
    }

    public void addMultipleObjectsDisplayListener(MultipleObjectsDisplayListener listener) {
        this.listenerList.add(MultipleObjectsDisplayListener.class, listener);
    }

    public void fireDomainDisplayEvent(DomainDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getDomain() != this.currentState.domain;
        if (!changed) {
            boolean bl2 = changed = this.currentState.node != null || this.currentState.map != null || this.currentState.dbEntity != null || this.currentState.objEntity != null || this.currentState.procedure != null || this.currentState.query != null || this.currentState.embeddable != null;
        }
        if (!e.isRefired()) {
            e.setDomainChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        DomainDisplayListener[] arr$ = (DomainDisplayListener[])this.listenerList.getListeners(DomainDisplayListener.class);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            DomainDisplayListener listener;
            DomainDisplayListener temp = listener = arr$[i$];
            temp.currentDomainChanged(e);
        }
        if (e.getDomain() == null) {
            this.getApplication().getActionManager().projectOpened();
        } else {
            this.getApplication().getActionManager().domainSelected();
        }
    }

    public void fireDomainEvent(DomainEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.removeFromHistory((EventObject)((Object)e));
        }
        DomainListener[] arr$ = (DomainListener[])this.listenerList.getListeners(DomainListener.class);
        int len$ = arr$.length;
        block3: for (int i$ = 0; i$ < len$; ++i$) {
            DomainListener listener;
            DomainListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 1: {
                    temp.domainChanged(e);
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DomainEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDataNodeDisplayEvent(DataNodeDisplayEvent e) {
        EventListener[] list;
        boolean changed;
        boolean bl = changed = e.getDataNode() != this.currentState.node;
        if (!changed) {
            boolean bl2 = changed = this.currentState.map != null || this.currentState.dbEntity != null || this.currentState.objEntity != null || this.currentState.procedure != null || this.currentState.query != null || this.currentState.embeddable != null;
        }
        if (!e.isRefired()) {
            e.setDataNodeChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        for (EventListener listener : list = this.listenerList.getListeners(DataNodeDisplayListener.class)) {
            ((DataNodeDisplayListener)listener).currentDataNodeChanged(e);
        }
    }

    public void fireDataNodeEvent(DataNodeEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.removeFromHistory((EventObject)((Object)e));
        }
        DataNodeListener[] arr$ = (DataNodeListener[])this.listenerList.getListeners(DataNodeListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            DataNodeListener listener;
            DataNodeListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.dataNodeAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.dataNodeChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.dataNodeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DataNodeEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDataMapDisplayEvent(DataMapDisplayEvent e) {
        EventListener[] list;
        boolean changed;
        boolean bl = changed = e.getDataMap() != this.currentState.map;
        if (!changed) {
            boolean bl2 = changed = this.currentState.dbEntity != null || this.currentState.objEntity != null || this.currentState.procedure != null || this.currentState.query != null || this.currentState.embeddable != null;
        }
        if (!e.isRefired()) {
            e.setDataMapChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        for (EventListener listener : list = this.listenerList.getListeners(DataMapDisplayListener.class)) {
            DataMapDisplayListener temp = (DataMapDisplayListener)listener;
            temp.currentDataMapChanged(e);
        }
    }

    public void fireDataMapEvent(DataMapEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.removeFromHistory((EventObject)((Object)e));
        }
        DataMapListener[] arr$ = (DataMapListener[])this.listenerList.getListeners(DataMapListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            DataMapListener eventListener;
            DataMapListener listener = eventListener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    listener.dataMapAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.dataMapChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.dataMapRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid DataMapEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireObjEntityEvent(EntityEvent e) {
        this.setDirty(true);
        if (e.getEntity().getDataMap() != null && e.getId() == 1) {
            e.getEntity().getDataMap().objEntityChanged(e);
        }
        if (e.getId() == 3) {
            this.removeFromHistory((EventObject)e);
        }
        ObjEntityListener[] arr$ = (ObjEntityListener[])this.listenerList.getListeners(ObjEntityListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            ObjEntityListener listener;
            ObjEntityListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.objEntityAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.objEntityChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.objEntityRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid EntityEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDbEntityEvent(EntityEvent e) {
        this.setDirty(true);
        if (e.getEntity().getDataMap() != null && e.getId() == 1) {
            e.getEntity().getDataMap().dbEntityChanged(e);
        }
        if (e.getId() == 3) {
            this.removeFromHistory((EventObject)e);
        }
        DbEntityListener[] arr$ = (DbEntityListener[])this.listenerList.getListeners(DbEntityListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            DbEntityListener listener;
            DbEntityListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.dbEntityAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.dbEntityChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.dbEntityRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid EntityEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireQueryEvent(QueryEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.removeFromHistory((EventObject)((Object)e));
        }
        QueryListener[] arr$ = (QueryListener[])this.listenerList.getListeners(QueryListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            QueryListener eventListener;
            QueryListener listener = eventListener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    listener.queryAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.queryChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.queryRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ProcedureEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireProcedureEvent(ProcedureEvent e) {
        this.setDirty(true);
        if (e.getId() == 3) {
            this.removeFromHistory((EventObject)((Object)e));
        }
        ProcedureListener[] arr$ = (ProcedureListener[])this.listenerList.getListeners(ProcedureListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            ProcedureListener eventListener;
            ProcedureListener listener = eventListener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    listener.procedureAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.procedureChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.procedureRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ProcedureEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireProcedureParameterEvent(ProcedureParameterEvent e) {
        EventListener[] list;
        this.setDirty(true);
        block5: for (EventListener eventListener : list = this.listenerList.getListeners(ProcedureParameterListener.class)) {
            ProcedureParameterListener listener = (ProcedureParameterListener)eventListener;
            switch (e.getId()) {
                case 2: {
                    listener.procedureParameterAdded(e);
                    continue block5;
                }
                case 1: {
                    listener.procedureParameterChanged(e);
                    continue block5;
                }
                case 3: {
                    listener.procedureParameterRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid ProcedureParameterEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireNavigationEvent(EventObject e) {
        int counter;
        Object source = e.getSource();
        if (source == null) {
            return;
        }
        int size = this.controllerStateHistory.size();
        if (size == 0) {
            return;
        }
        int i = this.controllerStateHistory.indexOf(this.currentState);
        ControllerState cs = null;
        if (size == 1) {
            cs = (ControllerState)this.controllerStateHistory.get(0);
        } else if (source instanceof NavigateForwardAction) {
            counter = 0;
            while ((cs = i < 0 ? (ControllerState)this.controllerStateHistory.get(0) : (i + 1 < size ? (ControllerState)this.controllerStateHistory.get(i + 1) : (ControllerState)this.controllerStateHistory.get(0))).isEquivalent(this.currentState) && ++counter <= 5) {
                ++i;
            }
        } else if (source instanceof NavigateBackwardAction) {
            counter = 0;
            while (true) {
                if (i < 0) {
                    try {
                        cs = (ControllerState)this.controllerStateHistory.get(size - 2);
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        cs = (ControllerState)this.controllerStateHistory.get(size - 1);
                    }
                } else {
                    cs = i - 1 >= 0 ? (ControllerState)this.controllerStateHistory.get(i - 1) : (ControllerState)this.controllerStateHistory.get(size - 1);
                }
                if (!cs.isEquivalent(this.currentState) || ++counter > 5) break;
                --i;
            }
        }
        this.currentState = cs;
        DisplayEvent de = cs.event;
        if (de == null) {
            return;
        }
        this.currentState.isRefiring = true;
        de.setRefired(true);
        if (de instanceof EntityDisplayEvent) {
            EntityDisplayEvent ede = (EntityDisplayEvent)de;
            ede.setEntityChanged(true);
            if (ede.getEntity() instanceof ObjEntity) {
                this.fireObjEntityDisplayEvent(ede);
            } else if (ede.getEntity() instanceof DbEntity) {
                this.fireDbEntityDisplayEvent(ede);
            }
        } else if (de instanceof EmbeddableDisplayEvent) {
            EmbeddableDisplayEvent ede = (EmbeddableDisplayEvent)de;
            ede.setEmbeddableChanged(true);
            this.fireEmbeddableDisplayEvent(ede);
        } else if (de instanceof ProcedureDisplayEvent) {
            ProcedureDisplayEvent pde = (ProcedureDisplayEvent)de;
            pde.setProcedureChanged(true);
            this.fireProcedureDisplayEvent(pde);
        } else if (de instanceof QueryDisplayEvent) {
            QueryDisplayEvent qde = (QueryDisplayEvent)de;
            qde.setQueryChanged(true);
            this.fireQueryDisplayEvent(qde);
        } else if (de instanceof DataMapDisplayEvent) {
            DataMapDisplayEvent dmde = (DataMapDisplayEvent)de;
            dmde.setDataMapChanged(true);
            this.fireDataMapDisplayEvent(dmde);
        } else if (de instanceof DataNodeDisplayEvent) {
            DataNodeDisplayEvent dnde = (DataNodeDisplayEvent)de;
            dnde.setDataNodeChanged(true);
            this.fireDataNodeDisplayEvent(dnde);
        } else if (de instanceof DomainDisplayEvent) {
            DomainDisplayEvent dde = (DomainDisplayEvent)de;
            dde.setDomainChanged(true);
            this.fireDomainDisplayEvent(dde);
        }
        this.currentState.isRefiring = false;
    }

    public void fireObjEntityDisplayEvent(EntityDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getEntity() != this.currentState.objEntity;
        if (!e.isRefired()) {
            e.setEntityChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
                this.currentState.objEntity = (ObjEntity)e.getEntity();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        ObjEntityDisplayListener[] arr$ = (ObjEntityDisplayListener[])this.listenerList.getListeners(ObjEntityDisplayListener.class);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ObjEntityDisplayListener listener;
            ObjEntityDisplayListener temp = listener = arr$[i$];
            temp.currentObjEntityChanged(e);
        }
    }

    public void fireEmbeddableDisplayEvent(EmbeddableDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getEmbeddable() != this.currentState.embeddable;
        if (!e.isRefired()) {
            e.setEmbeddableChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
                this.currentState.embeddable = e.getEmbeddable();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        EmbeddableDisplayListener[] arr$ = (EmbeddableDisplayListener[])this.listenerList.getListeners(EmbeddableDisplayListener.class);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EmbeddableDisplayListener listener;
            EmbeddableDisplayListener temp = listener = arr$[i$];
            temp.currentEmbeddableChanged(e);
        }
    }

    public void fireQueryDisplayEvent(QueryDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getQuery() != this.currentState.query;
        if (!e.isRefired()) {
            e.setQueryChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.query = e.getQuery();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        QueryDisplayListener[] arr$ = (QueryDisplayListener[])this.listenerList.getListeners(QueryDisplayListener.class);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            QueryDisplayListener eventListener;
            QueryDisplayListener listener = eventListener = arr$[i$];
            listener.currentQueryChanged(e);
        }
    }

    public void fireProcedureDisplayEvent(ProcedureDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getProcedure() != this.currentState.procedure;
        if (!e.isRefired()) {
            e.setProcedureChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.procedure = e.getProcedure();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        ProcedureDisplayListener[] arr$ = (ProcedureDisplayListener[])this.listenerList.getListeners(ProcedureDisplayListener.class);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ProcedureDisplayListener eventListener;
            ProcedureDisplayListener listener = eventListener = arr$[i$];
            listener.currentProcedureChanged(e);
        }
    }

    public void fireProcedureParameterDisplayEvent(ProcedureParameterDisplayEvent e) {
        EventListener[] list;
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getProcedureParameters(), this.currentState.procedureParameters);
        if (changed) {
            if (this.currentState.procedure != e.getProcedure()) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.procedure = e.getProcedure();
            }
            ControllerState.access$1502(this.currentState, e.getProcedureParameters());
        }
        for (EventListener eventListener : list = this.listenerList.getListeners(ProcedureParameterDisplayListener.class)) {
            ProcedureParameterDisplayListener listener = (ProcedureParameterDisplayListener)eventListener;
            listener.currentProcedureParameterChanged(e);
        }
    }

    public void fireDbEntityDisplayEvent(EntityDisplayEvent e) {
        boolean changed;
        boolean bl = changed = e.getEntity() != this.currentState.dbEntity;
        if (!e.isRefired()) {
            e.setEntityChanged(changed);
            if (changed) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.node = e.getDataNode();
                this.currentState.map = e.getDataMap();
                this.currentState.dbEntity = (DbEntity)e.getEntity();
            }
        }
        if (changed) {
            this.saveState(e);
        }
        DbEntityDisplayListener[] arr$ = (DbEntityDisplayListener[])this.listenerList.getListeners(DbEntityDisplayListener.class);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            DbEntityDisplayListener listener;
            DbEntityDisplayListener temp = listener = arr$[i$];
            temp.currentDbEntityChanged(e);
        }
    }

    public void fireDbAttributeEvent(AttributeEvent e) {
        this.setDirty(true);
        DbAttributeListener[] arr$ = (DbAttributeListener[])this.listenerList.getListeners(DbAttributeListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            DbAttributeListener listener;
            DbAttributeListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.dbAttributeAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.dbAttributeChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.dbAttributeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid AttributeEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDbAttributeDisplayEvent(AttributeDisplayEvent e) {
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getAttributes(), this.currentState.dbAttrs);
        if (changed) {
            if (e.getEntity() != this.currentState.dbEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.dbEntity = (DbEntity)e.getEntity();
            }
            ControllerState.access$902(this.currentState, new DbAttribute[e.getAttributes().length]);
            System.arraycopy(e.getAttributes(), 0, this.currentState.dbAttrs, 0, this.currentState.dbAttrs.length);
        }
        DbAttributeDisplayListener[] arr$ = (DbAttributeDisplayListener[])this.listenerList.getListeners(DbAttributeDisplayListener.class);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            DbAttributeDisplayListener listener;
            DbAttributeDisplayListener temp = listener = arr$[i$];
            temp.currentDbAttributeChanged(e);
        }
    }

    public void fireObjAttributeEvent(AttributeEvent e) {
        this.setDirty(true);
        ObjAttributeListener[] arr$ = (ObjAttributeListener[])this.listenerList.getListeners(ObjAttributeListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            ObjAttributeListener listener;
            ObjAttributeListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.objAttributeAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.objAttributeChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.objAttributeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid AttributeEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireObjAttributeDisplayEvent(AttributeDisplayEvent e) {
        EventListener[] list;
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getAttributes(), this.currentState.objAttrs);
        if (changed) {
            if (e.getEntity() != this.currentState.objEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.objEntity = (ObjEntity)e.getEntity();
            }
            ControllerState.access$802(this.currentState, new ObjAttribute[e.getAttributes().length]);
            System.arraycopy(e.getAttributes(), 0, this.currentState.objAttrs, 0, this.currentState.objAttrs.length);
        }
        for (EventListener listener : list = this.listenerList.getListeners(ObjAttributeDisplayListener.class)) {
            ObjAttributeDisplayListener temp = (ObjAttributeDisplayListener)listener;
            temp.currentObjAttributeChanged(e);
        }
    }

    public void fireEmbeddableAttributeDisplayEvent(EmbeddableAttributeDisplayEvent ev) {
        EventListener[] list;
        boolean changed;
        boolean bl = changed = !Arrays.equals(ev.getEmbeddableAttributes(), this.currentState.embAttrs);
        if (changed) {
            if (ev.getEmbeddable() != this.currentState.embeddable) {
                this.clearState();
                this.currentState.domain = ev.getDomain();
                this.currentState.map = ev.getDataMap();
                this.currentState.embeddable = ev.getEmbeddable();
            }
            ControllerState.access$1002(this.currentState, new EmbeddableAttribute[ev.getEmbeddableAttributes().length]);
            System.arraycopy(ev.getEmbeddableAttributes(), 0, this.currentState.embAttrs, 0, this.currentState.embAttrs.length);
        }
        for (EventListener listener : list = this.listenerList.getListeners(EmbeddableAttributeDisplayListener.class)) {
            EmbeddableAttributeDisplayListener temp = (EmbeddableAttributeDisplayListener)listener;
            temp.currentEmbeddableAttributeChanged(ev);
        }
    }

    public void fireDbRelationshipEvent(RelationshipEvent e) {
        this.setDirty(true);
        if (e.getId() == 1 && e.getEntity() instanceof DbEntity) {
            ((DbEntity)e.getEntity()).dbRelationshipChanged(e);
        }
        DbRelationshipListener[] arr$ = (DbRelationshipListener[])this.listenerList.getListeners(DbRelationshipListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            DbRelationshipListener listener;
            DbRelationshipListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.dbRelationshipAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.dbRelationshipChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.dbRelationshipRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireDbRelationshipDisplayEvent(RelationshipDisplayEvent e) {
        boolean changed;
        boolean bl = changed = !Arrays.equals(e.getRelationships(), this.currentState.dbRels);
        if (changed) {
            if (e.getEntity() != this.currentState.dbEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.dbEntity = (DbEntity)e.getEntity();
            }
            ControllerState.access$1202(this.currentState, new DbRelationship[e.getRelationships().length]);
            System.arraycopy(e.getRelationships(), 0, this.currentState.dbRels, 0, this.currentState.dbRels.length);
        }
        DbRelationshipDisplayListener[] arr$ = (DbRelationshipDisplayListener[])this.listenerList.getListeners(DbRelationshipDisplayListener.class);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            DbRelationshipDisplayListener listener;
            DbRelationshipDisplayListener temp = listener = arr$[i$];
            temp.currentDbRelationshipChanged(e);
        }
    }

    public void fireObjRelationshipEvent(RelationshipEvent e) {
        this.setDirty(true);
        ObjRelationshipListener[] arr$ = (ObjRelationshipListener[])this.listenerList.getListeners(ObjRelationshipListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            ObjRelationshipListener listener;
            ObjRelationshipListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.objRelationshipAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.objRelationshipChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.objRelationshipRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireMultipleObjectsDisplayEvent(MultipleObjectsDisplayEvent e) {
        EventListener[] list;
        this.clearState();
        ControllerState.access$1602(this.currentState, e.getNodes());
        this.currentState.parentPath = e.getParentNode();
        for (EventListener listener : list = this.listenerList.getListeners(MultipleObjectsDisplayListener.class)) {
            MultipleObjectsDisplayListener temp = (MultipleObjectsDisplayListener)listener;
            temp.currentObjectsChanged(e, this.getApplication());
        }
    }

    public void fireObjRelationshipDisplayEvent(RelationshipDisplayEvent e) {
        EventListener[] list;
        boolean changed = !Arrays.equals(e.getRelationships(), this.currentState.objRels);
        e.setRelationshipChanged(changed);
        if (changed) {
            if (e.getEntity() != this.currentState.objEntity) {
                this.clearState();
                this.currentState.domain = e.getDomain();
                this.currentState.map = e.getDataMap();
                this.currentState.objEntity = (ObjEntity)e.getEntity();
            }
            ControllerState.access$1102(this.currentState, new ObjRelationship[e.getRelationships().length]);
            System.arraycopy(e.getRelationships(), 0, this.currentState.objRels, 0, this.currentState.objRels.length);
        }
        for (EventListener listener : list = this.listenerList.getListeners(ObjRelationshipDisplayListener.class)) {
            ObjRelationshipDisplayListener temp = (ObjRelationshipDisplayListener)listener;
            temp.currentObjRelationshipChanged(e);
        }
    }

    public void addDataMap(Object src, DataMap map) {
        this.addDataMap(src, map, true);
    }

    public void addDataMap(Object src, DataMap map, boolean makeCurrent) {
        map.setDataChannelDescriptor(this.currentState.domain);
        this.currentState.domain.getDataMaps().add(map);
        if (this.currentState.node != null && !this.currentState.node.getDataMapNames().contains(map.getName())) {
            this.currentState.node.getDataMapNames().add(map.getName());
            this.fireDataNodeEvent(new DataNodeEvent(this, this.currentState.node));
        }
        this.fireDataMapEvent(new DataMapEvent(src, map, 2));
        if (makeCurrent) {
            this.fireDataMapDisplayEvent(new DataMapDisplayEvent(src, map, this.currentState.domain, this.currentState.node));
        }
    }

    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.enableSave(dirty);
            this.application.getActionManager().getAction(RevertAction.class).setEnabled(dirty);
            if (dirty) {
                ((CayenneModelerController)this.getParent()).projectModifiedAction();
            }
        }
    }

    public String getCurrentListenerClass() {
        return this.currentState.listenerClass;
    }

    public CallbackType getCurrentCallbackType() {
        return this.currentState.callbackType;
    }

    public ObjCallbackMethod[] getCurrentCallbackMethods() {
        return this.currentState.callbackMethods;
    }

    public void setCurrentListenerClass(String listenerClass) {
        this.currentState.listenerClass = listenerClass;
    }

    public void setCurrentCallbackType(CallbackType callbackType) {
        this.currentState.callbackType = callbackType;
    }

    public void setCurrentCallbackMethods(ObjCallbackMethod[] callbackMethods) {
        ControllerState.access$2002(this.currentState, callbackMethods);
    }

    public void addCallbackMethodListener(CallbackMethodListener listener) {
        this.listenerList.add(CallbackMethodListener.class, listener);
    }

    public void fireCallbackMethodEvent(CallbackMethodEvent e) {
        this.setDirty(true);
        CallbackMethodListener[] arr$ = (CallbackMethodListener[])this.listenerList.getListeners(CallbackMethodListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            CallbackMethodListener listener;
            CallbackMethodListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.callbackMethodAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.callbackMethodChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.callbackMethodRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid CallbackEvent type: " + e.getId());
                }
            }
        }
    }

    public void addEntityListenerListener(EntityListenerListener listener) {
        this.listenerList.add(EntityListenerListener.class, listener);
    }

    public void fireEntityListenerEvent(EntityListenerEvent e) {
        this.setDirty(true);
        EntityListenerListener[] arr$ = (EntityListenerListener[])this.listenerList.getListeners(EntityListenerListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            EntityListenerListener listener;
            EntityListenerListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.entityListenerAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.entityListenerChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.entityListenerRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid CallbackEvent type: " + e.getId());
                }
            }
        }
    }

    public ProjectFileChangeTracker getFileChangeTracker() {
        return this.fileChangeTracker;
    }

    public Object getCurrentObject() {
        if (this.getCurrentObjEntity() != null) {
            return this.getCurrentObjEntity();
        }
        if (this.getCurrentDbEntity() != null) {
            return this.getCurrentDbEntity();
        }
        if (this.getCurrentEmbeddable() != null) {
            return this.getCurrentEmbeddable();
        }
        if (this.getCurrentQuery() != null) {
            return this.getCurrentQuery();
        }
        if (this.getCurrentProcedure() != null) {
            return this.getCurrentProcedure();
        }
        if (this.getCurrentDataMap() != null) {
            return this.getCurrentDataMap();
        }
        if (this.getCurrentDataNode() != null) {
            return this.getCurrentDataNode();
        }
        if (this.getCurrentDataChanel() != null) {
            return this.getCurrentDataChanel();
        }
        if (this.getCurrentPaths() != null) {
            Object[] paths = this.getCurrentPaths();
            Vector<Object> result = new Vector<Object>();
            ConfigurationNodeParentGetter parentGetter = (ConfigurationNodeParentGetter)this.getApplication().getInjector().getInstance(ConfigurationNodeParentGetter.class);
            ConfigurationNode parent = parentGetter.getParent((ConfigurationNode)paths[0]);
            for (Object path : paths) {
                result.add(path);
            }
            Collections.sort(result, parent instanceof DataMap ? Comparators.getDataMapChildrenComparator() : Comparators.getDataDomainChildrenComparator());
            return result;
        }
        return null;
    }

    public void addEmbeddableAttributeListener(EmbeddableAttributeListener listener) {
        this.listenerList.add(EmbeddableAttributeListener.class, listener);
    }

    public void addEmbeddableListener(EmbeddableListener listener) {
        this.listenerList.add(EmbeddableListener.class, listener);
    }

    public void fireEmbeddableEvent(EmbeddableEvent e, DataMap map) {
        this.setDirty(true);
        EmbeddableListener[] arr$ = (EmbeddableListener[])this.listenerList.getListeners(EmbeddableListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            EmbeddableListener listener;
            EmbeddableListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.embeddableAdded(e, map);
                    continue block5;
                }
                case 1: {
                    temp.embeddableChanged(e, map);
                    continue block5;
                }
                case 3: {
                    temp.embeddableRemoved(e, map);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireEmbeddableAttributeEvent(EmbeddableAttributeEvent e) {
        this.setDirty(true);
        EmbeddableAttributeListener[] arr$ = (EmbeddableAttributeListener[])this.listenerList.getListeners(EmbeddableAttributeListener.class);
        int len$ = arr$.length;
        block5: for (int i$ = 0; i$ < len$; ++i$) {
            EmbeddableAttributeListener listener;
            EmbeddableAttributeListener temp = listener = arr$[i$];
            switch (e.getId()) {
                case 2: {
                    temp.embeddableAttributeAdded(e);
                    continue block5;
                }
                case 1: {
                    temp.embeddableAttributeChanged(e);
                    continue block5;
                }
                case 3: {
                    temp.embeddableAttributeRemoved(e);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Invalid RelationshipEvent type: " + e.getId());
                }
            }
        }
    }

    public void fireProjectOnSaveEvent(ProjectOnSaveEvent e) {
        ProjectOnSaveListener[] arr$ = (ProjectOnSaveListener[])this.listenerList.getListeners(ProjectOnSaveListener.class);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ProjectOnSaveListener listener;
            ProjectOnSaveListener temp = listener = arr$[i$];
            temp.beforeSaveChanges(e);
        }
    }

    public ArrayList<Embeddable> getEmbeddableNamesInCurRentDataDomain() {
        DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)this.getProject().getRootNode();
        Collection maps = dataChannelDescriptor.getDataMaps();
        Iterator it = maps.iterator();
        ArrayList<Embeddable> embs = new ArrayList<Embeddable>();
        while (it.hasNext()) {
            embs.addAll(((DataMap)it.next()).getEmbeddables());
        }
        return embs;
    }

    public void updateProjectControllerPreferences() {
        String key = this.getProject().getConfigurationResource() == null ? new String(IDUtil.pseudoUniqueByteSequence16()) : this.project.getConfigurationResource().getURL().getPath();
        this.projectControllerPreferences = Preferences.userNodeForPackage(Project.class);
        if (key.trim().length() > 0) {
            this.projectControllerPreferences = key.contains(".xml") ? this.projectControllerPreferences.node(this.projectControllerPreferences.absolutePath() + key.replace(".xml", "")) : this.projectControllerPreferences.node(this.projectControllerPreferences.absolutePath()).node(this.getApplication().getNewProjectTemporaryName());
        }
    }

    public int getEntityTabSelection() {
        return this.entityTabSelection;
    }

    public void setEntityTabSelection(int entityTabSelection) {
        this.entityTabSelection = entityTabSelection;
    }

    public void enableSave(boolean enable) {
        this.application.getActionManager().getAction(SaveAction.class).setEnabled(enable);
        this.application.getActionManager().getAction(SaveAsAction.class).setEnabled(enable);
    }

    public void setCurrentObjAttributes(ObjAttribute[] attrs) {
        ControllerState.access$802(this.currentState, attrs);
    }

    public void setCurrentObjRelationships(ObjRelationship[] rels) {
        ControllerState.access$1102(this.currentState, rels);
    }

    public void setCurrentDbAttributes(DbAttribute[] attrs) {
        ControllerState.access$902(this.currentState, attrs);
    }

    public void setCurrentDbRelationships(DbRelationship[] rels) {
        ControllerState.access$1202(this.currentState, rels);
    }

    public class ControllerState {
        private boolean isRefiring;
        private DisplayEvent event;
        private DataChannelDescriptor domain;
        private DataNodeDescriptor node;
        private DataMap map;
        private ObjEntity objEntity;
        private DbEntity dbEntity;
        private Embeddable embeddable;
        private EmbeddableAttribute[] embAttrs = new EmbeddableAttribute[0];
        private ObjAttribute[] objAttrs;
        private DbAttribute[] dbAttrs = new DbAttribute[0];
        private ObjRelationship[] objRels;
        private DbRelationship[] dbRels = new DbRelationship[0];
        private Procedure procedure;
        private ProcedureParameter[] procedureParameters = new ProcedureParameter[0];
        private Query query;
        private Object[] paths;
        private Object parentPath;
        private String listenerClass;
        private CallbackType callbackType;
        private ObjCallbackMethod[] callbackMethods;

        public ControllerState() {
            this.objAttrs = new ObjAttribute[0];
            this.objRels = new ObjRelationship[0];
            this.callbackMethods = new ObjCallbackMethod[0];
        }

        public boolean isEquivalent(ControllerState val) {
            if (val == null) {
                return false;
            }
            if (this.event instanceof EntityDisplayEvent && val.event instanceof EntityDisplayEvent) {
                if (((EntityDisplayEvent)val.event).getEntity() instanceof ObjEntity) {
                    return this.objEntity == val.objEntity;
                }
                return this.dbEntity == val.dbEntity;
            }
            if (this.event instanceof ProcedureDisplayEvent && val.event instanceof ProcedureDisplayEvent) {
                return this.procedure == val.procedure;
            }
            if (this.event instanceof QueryDisplayEvent && val.event instanceof QueryDisplayEvent) {
                return this.query == val.query;
            }
            if (this.event instanceof EmbeddableDisplayEvent && val.event instanceof EmbeddableDisplayEvent) {
                return this.embeddable == val.embeddable;
            }
            if (this.event.getClass() == DataMapDisplayEvent.class && this.event.getClass() == val.event.getClass()) {
                return this.map == val.map;
            }
            if (this.event.getClass() == DataNodeDisplayEvent.class && this.event.getClass() == val.event.getClass()) {
                return this.node == val.node;
            }
            if (this.event.getClass() == DomainDisplayEvent.class && this.event.getClass() == val.event.getClass()) {
                return this.domain == val.domain;
            }
            return false;
        }

        static /* synthetic */ ProcedureParameter[] access$1502(ControllerState x0, ProcedureParameter[] x1) {
            x0.procedureParameters = x1;
            return x1;
        }

        static /* synthetic */ DbAttribute[] access$902(ControllerState x0, DbAttribute[] x1) {
            x0.dbAttrs = x1;
            return x1;
        }

        static /* synthetic */ ObjAttribute[] access$802(ControllerState x0, ObjAttribute[] x1) {
            x0.objAttrs = x1;
            return x1;
        }

        static /* synthetic */ EmbeddableAttribute[] access$1002(ControllerState x0, EmbeddableAttribute[] x1) {
            x0.embAttrs = x1;
            return x1;
        }

        static /* synthetic */ DbRelationship[] access$1202(ControllerState x0, DbRelationship[] x1) {
            x0.dbRels = x1;
            return x1;
        }

        static /* synthetic */ Object[] access$1602(ControllerState x0, Object[] x1) {
            x0.paths = x1;
            return x1;
        }

        static /* synthetic */ ObjRelationship[] access$1102(ControllerState x0, ObjRelationship[] x1) {
            x0.objRels = x1;
            return x1;
        }

        static /* synthetic */ ObjCallbackMethod[] access$2002(ControllerState x0, ObjCallbackMethod[] x1) {
            x0.callbackMethods = x1;
            return x1;
        }
    }
}

