/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.dialog.FileDeletedDialog;
import org.apache.cayenne.project.Project;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProjectFileChangeTracker
extends Thread {
    private static final Log log = LogFactory.getLog(ProjectFileChangeTracker.class);
    private static final long DEFAULT_DELAY = 4000L;
    protected Map<String, FileInfo> files = new ConcurrentHashMap<String, FileInfo>();
    protected boolean paused;
    protected ProjectController mediator;

    public ProjectFileChangeTracker(ProjectController mediator) {
        this.mediator = mediator;
        this.setName("cayenne-modeler-file-change-tracker");
    }

    public void reconfigure() {
        this.pauseWatching();
        this.removeAllFiles();
        Project project = this.mediator.getProject();
        if (project != null && project.getConfigurationResource() != null) {
            String projectPath = project.getConfigurationResource().getURL().getPath() + File.separator;
            this.addFile(projectPath);
            for (DataMap dm : ((DataChannelDescriptor)project.getRootNode()).getDataMaps()) {
                this.addFile(dm.getConfigurationSource().getURL().getPath());
            }
        }
        this.resumeWatching();
    }

    protected void doOnChange() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ProjectFileChangeTracker.this.showConfirmation("One or more project files were changed by external program. Do you want to load the changes?")) {
                    if (ProjectFileChangeTracker.this.mediator.getProject() != null) {
                        File fileDirectory = new File(ProjectFileChangeTracker.this.mediator.getProject().getConfigurationResource().getURL().getPath());
                        Application.getInstance().getActionManager().getAction(OpenProjectAction.class).openProject(fileDirectory);
                    }
                } else {
                    ProjectFileChangeTracker.this.mediator.setDirty(true);
                }
            }
        });
    }

    protected void doOnRemove() {
        if (this.mediator.getProject() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileDeletedDialog dialog = new FileDeletedDialog(Application.getFrame());
                    dialog.show();
                    if (dialog.shouldSave()) {
                        Application.getInstance().getActionManager().getAction(SaveAction.class).performAction(null);
                    } else if (dialog.shouldClose()) {
                        Application.getInstance().getFrameController().projectClosedAction();
                    } else {
                        ProjectFileChangeTracker.this.mediator.setDirty(true);
                    }
                }
            });
        }
    }

    private boolean showConfirmation(String message) {
        return 0 == JOptionPane.showConfirmDialog(Application.getFrame(), message, "File changed", 0, 3);
    }

    public void addFile(String location) {
        try {
            this.files.put(location, new FileInfo(location));
        }
        catch (SecurityException e) {
            log.error((Object)("SecurityException adding file " + location), (Throwable)e);
        }
    }

    public void removeFile(String location) {
        this.files.remove(location);
    }

    public void removeAllFiles() {
        this.files.clear();
    }

    protected void check() {
        if (this.paused) {
            return;
        }
        boolean hasChanges = false;
        boolean hasDeletions = false;
        Iterator<FileInfo> it = this.files.values().iterator();
        while (it.hasNext()) {
            boolean fileExists;
            FileInfo fi = it.next();
            try {
                fileExists = fi.getFile().exists();
            }
            catch (SecurityException e) {
                log.error((Object)("SecurityException checking file " + fi.getFile().getPath()), (Throwable)e);
                continue;
            }
            if (fileExists) {
                long l = fi.getFile().lastModified();
                if (l <= fi.getLastModified()) continue;
                fi.setLastModified(l);
                hasChanges = true;
                continue;
            }
            if (fi.getLastModified() == -1L) continue;
            hasDeletions = true;
            it.remove();
        }
        if (hasDeletions) {
            this.doOnRemove();
        } else if (hasChanges) {
            this.doOnChange();
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(4000L);
                this.check();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public void pauseWatching() {
        this.paused = true;
    }

    public void resumeWatching() {
        this.paused = false;
    }

    protected class FileInfo {
        File file;
        long lastModified;

        public FileInfo(String location) {
            this.file = new File(location);
            this.lastModified = this.file.exists() ? this.file.lastModified() : -1L;
        }

        public File getFile() {
            return this.file;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long l) {
            this.lastModified = l;
        }
    }
}

