/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EmbeddableAttributeEvent;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.NameChecker;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateAttributeUndoableEdit;
import org.apache.cayenne.modeler.undo.CreateEmbAttributeUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CreateAttributeAction
extends CayenneAction {
    public static String getActionName() {
        return "Create Attribute";
    }

    public CreateAttributeAction(Application application) {
        super(CreateAttributeAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-attribute.gif";
    }

    @Override
    public void performAction(ActionEvent e) {
        EmbeddableAttribute attr;
        ProjectController mediator = this.getProjectController();
        if (this.getProjectController().getCurrentEmbeddable() != null) {
            Embeddable embeddable = mediator.getCurrentEmbeddable();
            attr = new EmbeddableAttribute();
            attr.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.embeddableAttribute, (Object)embeddable));
            this.createEmbAttribute(embeddable, attr);
            this.application.getUndoManager().addEdit(new CreateEmbAttributeUndoableEdit(embeddable, new EmbeddableAttribute[]{attr}));
        }
        if (this.getProjectController().getCurrentObjEntity() != null) {
            ObjEntity objEntity = mediator.getCurrentObjEntity();
            attr = new ObjAttribute(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.objAttribute, (Object)objEntity), null, objEntity);
            this.createObjAttribute(mediator.getCurrentDataMap(), objEntity, (ObjAttribute)attr);
            this.application.getUndoManager().addEdit(new CreateAttributeUndoableEdit((DataChannelDescriptor)mediator.getProject().getRootNode(), mediator.getCurrentDataMap(), objEntity, (ObjAttribute)attr));
        } else if (this.getProjectController().getCurrentDbEntity() != null) {
            DbEntity dbEntity = this.getProjectController().getCurrentDbEntity();
            attr = new DbAttribute(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dbAttribute, (Object)dbEntity), Integer.MAX_VALUE, dbEntity);
            this.createDbAttribute(mediator.getCurrentDataMap(), dbEntity, (DbAttribute)attr);
            this.application.getUndoManager().addEdit(new CreateAttributeUndoableEdit((DataChannelDescriptor)mediator.getProject().getRootNode(), mediator.getCurrentDataMap(), dbEntity, (DbAttribute)attr));
        }
    }

    public void createEmbAttribute(Embeddable embeddable, EmbeddableAttribute attr) {
        ProjectController mediator = this.getProjectController();
        embeddable.addAttribute(attr);
        CreateAttributeAction.fireEmbeddableAttributeEvent(this, mediator, embeddable, attr);
    }

    static void fireEmbeddableAttributeEvent(Object src, ProjectController mediator, Embeddable embeddable, EmbeddableAttribute attr) {
        mediator.fireEmbeddableAttributeEvent(new EmbeddableAttributeEvent(src, attr, embeddable, 2));
        EmbeddableAttributeDisplayEvent e = new EmbeddableAttributeDisplayEvent(src, embeddable, attr, mediator.getCurrentDataMap(), (DataChannelDescriptor)mediator.getProject().getRootNode());
        mediator.fireEmbeddableAttributeDisplayEvent(e);
    }

    public void createObjAttribute(DataMap map, ObjEntity objEntity, ObjAttribute attr) {
        ProjectController mediator = this.getProjectController();
        objEntity.addAttribute((Attribute)attr);
        CreateAttributeAction.fireObjAttributeEvent(this, mediator, map, objEntity, attr);
    }

    static void fireObjAttributeEvent(Object src, ProjectController mediator, DataMap map, ObjEntity objEntity, ObjAttribute attr) {
        mediator.fireObjAttributeEvent(new AttributeEvent(src, (Attribute)attr, (Entity)objEntity, 2));
        DataChannelDescriptor domain = (DataChannelDescriptor)mediator.getProject().getRootNode();
        AttributeDisplayEvent ade = new AttributeDisplayEvent(src, (Attribute)attr, (Entity)objEntity, map, domain);
        mediator.fireObjAttributeDisplayEvent(ade);
    }

    public void createDbAttribute(DataMap map, DbEntity dbEntity, DbAttribute attr) {
        dbEntity.addAttribute(attr);
        ProjectController mediator = this.getProjectController();
        CreateAttributeAction.fireDbAttributeEvent(this, mediator, map, dbEntity, attr);
    }

    static void fireDbAttributeEvent(Object src, ProjectController mediator, DataMap map, DbEntity dbEntity, DbAttribute attr) {
        mediator.fireDbAttributeEvent(new AttributeEvent(src, (Attribute)attr, (Entity)dbEntity, 2));
        AttributeDisplayEvent ade = new AttributeDisplayEvent(src, (Attribute)attr, (Entity)dbEntity, map, (DataChannelDescriptor)mediator.getProject().getRootNode());
        mediator.fireDbAttributeDisplayEvent(ade);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Attribute) {
            return ((Attribute)object).getParent() != null && ((Attribute)object).getParent() instanceof Entity;
        }
        return false;
    }
}

