/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.NameChecker;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.map.naming.NameConverter;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.undo.CreateCallbackMethodUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CreateCallbackMethodAction
extends CayenneAction {
    public static final String ACTION_NAME = "Create callback method";

    public CreateCallbackMethodAction(String actionName, Application application) {
        super(actionName, application);
    }

    public CallbackMap getCallbackMap() {
        return this.getProjectController().getCurrentObjEntity().getCallbackMap();
    }

    @Override
    public String getIconName() {
        return "icon-create-method.gif";
    }

    @Override
    public final void performAction(ActionEvent e) {
        CallbackType callbackType = this.getProjectController().getCurrentCallbackType();
        String methodNamePrefix = this.toMethodName(callbackType.getType());
        String methodName = DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.objCallbackMethod, (Object)this.getProjectController().getCurrentObjEntity(), (String)methodNamePrefix);
        this.createCallbackMethod(callbackType, methodName);
        this.application.getUndoManager().addEdit(new CreateCallbackMethodUndoableEdit(callbackType, methodName));
    }

    public void createCallbackMethod(CallbackType callbackType, String methodName) {
        this.getCallbackMap().getCallbackDescriptor(callbackType.getType()).addCallbackMethod(methodName);
        CallbackMethodEvent ce = new CallbackMethodEvent(this, null, methodName, 2);
        this.getProjectController().fireCallbackMethodEvent(ce);
    }

    private String toMethodName(LifecycleEvent event) {
        return "on" + NameConverter.underscoredToJava((String)event.name(), (boolean)true);
    }

    public static String getActionName() {
        return ACTION_NAME;
    }

    public CreateCallbackMethodAction(Application application) {
        super(ACTION_NAME, application);
    }
}

