/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.CreateObjEntityListenerAction;
import org.apache.cayenne.modeler.event.EntityListenerEvent;
import org.apache.cayenne.modeler.undo.CreateDataMapEntityListenerUndoableEdit;

public class CreateDataMapEntityListenerAction
extends CreateObjEntityListenerAction {
    private static final String CREATE_ENTITY_LISTENER = "Create datamap entity listener";

    public CreateDataMapEntityListenerAction(Application application) {
        super(CreateDataMapEntityListenerAction.getActionName(), application);
    }

    public static String getActionName() {
        return CREATE_ENTITY_LISTENER;
    }

    @Override
    protected boolean isListenerClassAlreadyExists(String className) {
        return this.getProjectController().getCurrentDataMap().getDefaultEntityListener(className) != null;
    }

    protected void addEntityListener(EntityListener listener) {
        this.getProjectController().getCurrentDataMap().addDefaultEntityListener(listener);
    }

    @Override
    public void performAction(ActionEvent e) {
        String listenerClass = JOptionPane.showInputDialog("Please enter listener class:");
        if (listenerClass != null && listenerClass.trim().length() > 0) {
            if (this.isListenerClassAlreadyExists(listenerClass)) {
                JOptionPane.showMessageDialog(null, "Listener class already exists.", "Error creating entity listener", 0);
            } else {
                DataMap dataMap = this.getProjectController().getCurrentDataMap();
                if (dataMap != null) {
                    EntityListener listener = new EntityListener(listenerClass);
                    this.createMapListener(dataMap, listener);
                    this.application.getUndoManager().addEdit(new CreateDataMapEntityListenerUndoableEdit(dataMap, listener));
                }
            }
        }
    }

    public void createMapListener(DataMap dataMap, EntityListener listener) {
        dataMap.addDefaultEntityListener(listener);
        this.getProjectController().fireEntityListenerEvent(new EntityListenerEvent(this, listener.getClassName(), listener.getClassName(), 2));
    }
}

