/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.NameChecker;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateEmbeddableUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CreateEmbeddableAction
extends CayenneAction {
    public static String getActionName() {
        return "Create Embeddable";
    }

    public CreateEmbeddableAction(Application application) {
        super(CreateEmbeddableAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-new_embeddable.gif";
    }

    @Override
    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        DataMap dataMap = mediator.getCurrentDataMap();
        Embeddable embeddable = new Embeddable(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.embeddable, (Object)mediator.getCurrentDataMap()));
        this.createEmbeddable(dataMap, embeddable);
        this.application.getUndoManager().addEdit(new CreateEmbeddableUndoableEdit(dataMap, embeddable));
    }

    public void createEmbeddable(DataMap dataMap, Embeddable embeddable) {
        dataMap.addEmbeddable(embeddable);
        CreateEmbeddableAction.fireEmbeddableEvent(this, this.getProjectController(), dataMap, embeddable);
    }

    static void fireEmbeddableEvent(Object src, ProjectController mediator, DataMap dataMap, Embeddable embeddable) {
        mediator.fireEmbeddableEvent(new EmbeddableEvent(src, embeddable, 2), dataMap);
        EmbeddableDisplayEvent displayEvent = new EmbeddableDisplayEvent(src, embeddable, dataMap, (DataChannelDescriptor)mediator.getProject().getRootNode());
        displayEvent.setMainTabFocus(true);
        mediator.fireEmbeddableDisplayEvent(displayEvent);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ObjEntity) {
            return ((ObjEntity)object).getParent() != null && ((ObjEntity)object).getParent() instanceof DataMap;
        }
        return false;
    }
}

