/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.apache.cayenne.map.EntityListener;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.event.EntityListenerEvent;
import org.apache.cayenne.modeler.undo.CreateEntityListenerUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CreateObjEntityListenerAction
extends CayenneAction {
    private static final String CREATE_ENTITY_LISTENER = "Create objentity entity listener";

    public CreateObjEntityListenerAction(Application application) {
        super(CreateObjEntityListenerAction.getActionName(), application);
    }

    protected CreateObjEntityListenerAction(String actionName, Application application) {
        super(actionName, application);
    }

    public static String getActionName() {
        return CREATE_ENTITY_LISTENER;
    }

    @Override
    public String getIconName() {
        return "icon-create-listener.gif";
    }

    protected boolean isListenerClassAlreadyExists(String className) {
        return this.getProjectController().getCurrentObjEntity().getEntityListener(className) != null;
    }

    @Override
    public void performAction(ActionEvent e) {
        String listenerClass = JOptionPane.showInputDialog("Please enter listener class:");
        if (listenerClass != null && listenerClass.trim().length() > 0) {
            if (this.isListenerClassAlreadyExists(listenerClass)) {
                JOptionPane.showMessageDialog(null, "Listener class already exists.", "Error creating entity listener", 0);
            } else {
                ObjEntity objEntity = this.getProjectController().getCurrentObjEntity();
                EntityListener listener = new EntityListener(listenerClass);
                this.createEntityListener(objEntity, listener);
                this.application.getUndoManager().addEdit(new CreateEntityListenerUndoableEdit(objEntity, listener));
            }
        }
    }

    public void createEntityListener(ObjEntity objEntity, EntityListener listener) {
        objEntity.addEntityListener(listener);
        this.getProjectController().fireEntityListenerEvent(new EntityListenerEvent(this, listener.getClassName(), listener.getClassName(), 2));
    }
}

