/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.NameChecker;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateRelationshipUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.util.DeleteRuleUpdater;

public class CreateRelationshipAction
extends CayenneAction {
    public static String getActionName() {
        return "Create Relationship";
    }

    public CreateRelationshipAction(Application application) {
        super(CreateRelationshipAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-relationship.gif";
    }

    @Override
    public void performAction(ActionEvent e) {
        ObjEntity objEnt = this.getProjectController().getCurrentObjEntity();
        if (objEnt != null) {
            ObjRelationship rel = new ObjRelationship(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.objRelationship, (Object)objEnt));
            this.createObjRelationship(objEnt, rel);
            this.application.getUndoManager().addEdit(new CreateRelationshipUndoableEdit(objEnt, new ObjRelationship[]{rel}));
        } else {
            DbEntity dbEnt = this.getProjectController().getCurrentDbEntity();
            if (dbEnt != null) {
                DbRelationship rel = new DbRelationship(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dbRelationship, (Object)dbEnt));
                this.createDbRelationship(dbEnt, rel);
                this.application.getUndoManager().addEdit(new CreateRelationshipUndoableEdit(dbEnt, new DbRelationship[]{rel}));
            }
        }
    }

    public void createObjRelationship(ObjEntity objEntity, ObjRelationship rel) {
        ProjectController mediator = this.getProjectController();
        rel.setSourceEntity((Entity)objEntity);
        DeleteRuleUpdater.updateObjRelationship((ObjRelationship)rel);
        objEntity.addRelationship((Relationship)rel);
        CreateRelationshipAction.fireObjRelationshipEvent(this, mediator, objEntity, rel);
    }

    static void fireObjRelationshipEvent(Object src, ProjectController mediator, ObjEntity objEntity, ObjRelationship rel) {
        mediator.fireObjRelationshipEvent(new RelationshipEvent(src, (Relationship)rel, (Entity)objEntity, 2));
        RelationshipDisplayEvent rde = new RelationshipDisplayEvent(src, (Relationship)rel, (Entity)objEntity, mediator.getCurrentDataMap(), (DataChannelDescriptor)mediator.getProject().getRootNode());
        mediator.fireObjRelationshipDisplayEvent(rde);
    }

    public void createDbRelationship(DbEntity dbEntity, DbRelationship rel) {
        ProjectController mediator = this.getProjectController();
        rel.setSourceEntity((Entity)dbEntity);
        dbEntity.addRelationship((Relationship)rel);
        CreateRelationshipAction.fireDbRelationshipEvent(this, mediator, dbEntity, rel);
    }

    static void fireDbRelationshipEvent(Object src, ProjectController mediator, DbEntity dbEntity, DbRelationship rel) {
        mediator.fireDbRelationshipEvent(new RelationshipEvent(src, (Relationship)rel, (Entity)dbEntity, 2));
        RelationshipDisplayEvent rde = new RelationshipDisplayEvent(src, (Relationship)rel, (Entity)dbEntity, mediator.getCurrentDataMap(), (DataChannelDescriptor)mediator.getProject().getRootNode());
        mediator.fireDbRelationshipDisplayEvent(rde);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Relationship) {
            return ((Relationship)object).getParent() != null && ((Relationship)object).getParent() instanceof Entity;
        }
        return false;
    }
}

