/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.util.Collection;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.XMLPoolingDataSourceFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.pref.DataNodeDefaults;
import org.apache.cayenne.modeler.util.CayenneAction;

public abstract class DBWizardAction
extends CayenneAction {
    public DBWizardAction(String name, Application application) {
        super(name, application);
    }

    protected DataNodeDescriptor getPreferredNode() {
        DataMap map;
        ProjectController projectController = this.getProjectController();
        DataNodeDescriptor node = projectController.getCurrentDataNode();
        if (node == null && (map = projectController.getCurrentDataMap()) != null) {
            Collection nodes = ((DataChannelDescriptor)projectController.getProject().getRootNode()).getNodeDescriptors();
            for (DataNodeDescriptor n : nodes) {
                if (!n.getDataMapNames().contains(map.getName())) continue;
                node = n;
                break;
            }
        }
        return node;
    }

    protected String preferredDataSourceLabel(DBConnectionInfo nodeInfo) {
        if (nodeInfo == null) {
            DataNodeDescriptor node = this.getPreferredNode();
            return node != null && XMLPoolingDataSourceFactory.class.getName().equals(node.getDataSourceFactoryType()) ? "DataNode Connection Info" : null;
        }
        return nodeInfo.getNodeName();
    }

    protected DBConnectionInfo preferredDataSource() {
        DBConnectionInfo info;
        String key;
        DataNodeDescriptor node = this.getPreferredNode();
        if (node == null) {
            return null;
        }
        DataNodeDefaults nodeDefaults = (DataNodeDefaults)this.getApplication().getCayenneProjectPreferences().getProjectDetailObject(DataNodeDefaults.class, this.getProjectController().getPreferenceForDataDomain().node("DataNode").node(node.getName()));
        String string = key = nodeDefaults != null ? nodeDefaults.getLocalDataSource() : null;
        if (key != null && (info = (DBConnectionInfo)this.getApplication().getCayenneProjectPreferences().getDetailObject(DBConnectionInfo.class).getObject(key)) != null) {
            return info;
        }
        if (!XMLPoolingDataSourceFactory.class.getName().equals(node.getDataSourceFactoryType())) {
            return null;
        }
        DBConnectionInfo nodeInfo = new DBConnectionInfo();
        nodeInfo.copyFrom(node.getDataSourceDescriptor());
        nodeInfo.setDbAdapter(node.getAdapterType());
        return nodeInfo;
    }
}

