/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.tree.TreePath;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.ProjectTreeModel;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;

public class DbEntityCounterpartAction
extends CayenneAction {
    public static String getActionName() {
        return "View related ObjEntity";
    }

    public DbEntityCounterpartAction(Application application) {
        super(DbEntityCounterpartAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-move_up.gif";
    }

    @Override
    public void performAction(ActionEvent e) {
        this.viewCounterpartEntity();
    }

    protected void viewCounterpartEntity() {
        ProjectController mediator = this.getProjectController();
        DbEntity dbEntity = mediator.getCurrentDbEntity();
        if (dbEntity == null) {
            return;
        }
        Iterator it = dbEntity.getDataMap().getMappedEntities(dbEntity).iterator();
        if (!it.hasNext()) {
            return;
        }
        ObjEntity entity = (ObjEntity)it.next();
        TreePath path = DbEntityCounterpartAction.buildTreePath((Entity)entity);
        DbEntityCounterpartAction.editor().getProjectTreeView().getSelectionModel().setSelectionPath(path);
        EntityDisplayEvent event = new EntityDisplayEvent((Object)DbEntityCounterpartAction.editor().getProjectTreeView(), (Entity)entity, entity.getDataMap(), (DataChannelDescriptor)this.getProjectController().getProject().getRootNode());
        this.getProjectController().fireObjEntityDisplayEvent(event);
    }

    public static EditorView editor() {
        return ((CayenneModelerFrame)Application.getInstance().getFrameController().getView()).getView();
    }

    public static TreePath buildTreePath(Entity entity) {
        DataChannelDescriptor domain = (DataChannelDescriptor)Application.getInstance().getProject().getRootNode();
        Object[] path = new Object[]{domain, entity.getDataMap(), entity};
        Object[] mutableTreeNodes = new Object[path.length];
        mutableTreeNodes[0] = ((ProjectTreeModel)DbEntityCounterpartAction.editor().getProjectTreeView().getModel()).getRootNode();
        for (int i = 1; i < path.length; ++i) {
            Object[] helper = new Object[i];
            int j = 0;
            while (j < i) {
                helper[j++] = path[j];
            }
            mutableTreeNodes[i] = ((ProjectTreeModel)DbEntityCounterpartAction.editor().getProjectTreeView().getModel()).getNodeForObjectPath(helper);
        }
        return new TreePath(mutableTreeNodes);
    }
}

