/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorController;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.project.Project;

public class GenerateCodeAction
extends CayenneAction {
    public static String getActionName() {
        return "Generate Classes";
    }

    public GenerateCodeAction(Application application) {
        super(GenerateCodeAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-gen_java.gif";
    }

    @Override
    public void performAction(ActionEvent e) {
        DataMap dataMap = this.getProjectController().getCurrentDataMap();
        if (dataMap != null) {
            ArrayList<DataMap> dataMaps = new ArrayList<DataMap>();
            dataMaps.add(dataMap);
            new CodeGeneratorController(this.getApplication().getFrameController(), dataMaps).startup();
        } else if (this.getProjectController().getCurrentDataNode() != null) {
            Collection nodeMaps = this.getProjectController().getCurrentDataNode().getDataMapNames();
            Project project = this.getProjectController().getProject();
            Collection dataMaps = ((DataChannelDescriptor)project.getRootNode()).getDataMaps();
            ArrayList<DataMap> resultMaps = new ArrayList<DataMap>();
            for (DataMap map : dataMaps) {
                if (!nodeMaps.contains(map.getName())) continue;
                resultMaps.add(map);
            }
            new CodeGeneratorController(this.getApplication().getFrameController(), resultMaps).startup();
        } else {
            Project project = this.getProjectController().getProject();
            Collection dataMaps = ((DataChannelDescriptor)project.getRootNode()).getDataMaps();
            new CodeGeneratorController(this.getApplication().getFrameController(), dataMaps).startup();
        }
    }
}

