/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.NameChecker;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.cayenne.resource.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;

public class ImportDataMapAction
extends CayenneAction {
    private static Log logObj = LogFactory.getLog(ImportDataMapAction.class);

    public static String getActionName() {
        return "Import DataMap";
    }

    public ImportDataMapAction(Application application) {
        super(ImportDataMapAction.getActionName(), application);
    }

    @Override
    public void performAction(ActionEvent e) {
        this.importDataMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importDataMap() {
        File dataMapFile = this.selectDataMap(Application.getFrame());
        if (dataMapFile == null) {
            return;
        }
        try {
            DataMap newMap;
            URL url = dataMapFile.toURI().toURL();
            InputStream in = url.openStream();
            try {
                InputSource inSrc = new InputSource(in);
                inSrc.setSystemId(dataMapFile.getAbsolutePath());
                newMap = new MapLoader().loadDataMap(inSrc);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioex) {}
            }
            DataChannelDescriptor domain = (DataChannelDescriptor)this.getProjectController().getProject().getRootNode();
            if (newMap.getName() != null) {
                newMap.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dataMap, (Object)domain, (String)newMap.getName()));
            } else {
                newMap.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dataMap, (Object)domain));
            }
            Resource baseResource = domain.getConfigurationSource();
            if (baseResource != null) {
                Resource dataMapResource = baseResource.getRelativeResource(newMap.getName());
                newMap.setConfigurationSource(dataMapResource);
            }
            this.getProjectController().addDataMap(this, newMap);
        }
        catch (Exception ex) {
            logObj.info((Object)"Error importing DataMap.", (Throwable)ex);
            JOptionPane.showMessageDialog(Application.getFrame(), "Error reading DataMap: " + ex.getMessage(), "Can't Open DataMap", 0);
        }
    }

    protected File selectDataMap(Frame f) {
        FSPath lastDir = this.getApplication().getFrameController().getLastDirectory();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        lastDir.updateChooser(chooser);
        chooser.addChoosableFileFilter(FileFilters.getDataMapFilter());
        int status = chooser.showDialog(f, "Select DataMap");
        if (status == 0) {
            File file = chooser.getSelectedFile();
            lastDir.updateFromChooser(chooser);
            return file;
        }
        return null;
    }
}

