/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.sql.DataSource;
import javax.swing.JOptionPane;
import org.apache.cayenne.access.DbLoader;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.DBWizardAction;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.dialog.db.DbMigrateOptionsDialog;
import org.apache.cayenne.modeler.dialog.db.MergerOptions;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;

public class MigrateAction
extends DBWizardAction {
    public static String getActionName() {
        return "Migrate Database Schema";
    }

    public MigrateAction(Application application) {
        super(MigrateAction.getActionName(), application);
    }

    @Override
    public void performAction(ActionEvent e) {
        DBConnectionInfo nodeInfo = this.preferredDataSource();
        String nodeKey = this.preferredDataSourceLabel(nodeInfo);
        DataSourceWizard connectWizard = new DataSourceWizard(this.getProjectController(), "Migrate DB Schema: Connect to Database", nodeKey, nodeInfo);
        if (!connectWizard.startupAction()) {
            return;
        }
        DataMap map = this.getProjectController().getCurrentDataMap();
        if (map == null) {
            throw new IllegalStateException("No current DataMap selected.");
        }
        String selectedSchema = null;
        try {
            List<String> schemas = this.getSchemas(connectWizard);
            if (schemas != null && !schemas.isEmpty()) {
                DbMigrateOptionsDialog optionsDialog = new DbMigrateOptionsDialog(schemas, connectWizard.getConnectionInfo().getUserName());
                optionsDialog.showDialog();
                if (optionsDialog.getChoice() == 1) {
                    selectedSchema = optionsDialog.getSelectedSchema();
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Application.getFrame(), ex.getMessage(), "Error loading schemas dialog", 0);
        }
        new MergerOptions(this.getProjectController(), "Migrate DB Schema: Options", connectWizard.getConnectionInfo(), map, selectedSchema).startupAction();
    }

    private List<String> getSchemas(DataSourceWizard connectWizard) throws Exception {
        DbAdapter dbAdapter = connectWizard.getConnectionInfo().makeAdapter(this.getApplication().getClassLoadingService());
        DataSource dataSource = connectWizard.getConnectionInfo().makeDataSource(this.getApplication().getClassLoadingService());
        return new DbLoader(dataSource.getConnection(), dbAdapter, null).getSchemas();
    }
}

