/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.NameChecker;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.action.ProjectAction;
import org.apache.cayenne.modeler.event.DomainDisplayEvent;
import org.apache.cayenne.project.Project;

public class NewProjectAction
extends ProjectAction {
    public static String getActionName() {
        return "New Project";
    }

    public NewProjectAction(Application application) {
        super(NewProjectAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-new.gif";
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    @Override
    public void performAction(ActionEvent e) {
        CayenneModelerController controller = Application.getInstance().getFrameController();
        if (this.getCurrentProject() != null && !this.closeProject(true)) {
            return;
        }
        DataChannelDescriptor domain = new DataChannelDescriptor();
        domain.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dataChannelDescriptor, (Object)domain));
        Project project = new Project(new ConfigurationTree((ConfigurationNode)domain));
        controller.projectOpenedAction(project);
        this.getProjectController().fireDomainDisplayEvent(new DomainDisplayEvent((Object)this, domain));
    }
}

