/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.DbEntityCounterpartAction;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;

public class ObjEntityCounterpartAction
extends CayenneAction {
    public static String getActionName() {
        return "View related DbEntity";
    }

    public ObjEntityCounterpartAction(Application application) {
        super(ObjEntityCounterpartAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-move_down.gif";
    }

    @Override
    public void performAction(ActionEvent e) {
        this.viewCounterpartEntity();
    }

    protected void viewCounterpartEntity() {
        ProjectController mediator = this.getProjectController();
        ObjEntity objEntity = mediator.getCurrentObjEntity();
        if (objEntity == null) {
            return;
        }
        DbEntity entity = objEntity.getDbEntity();
        TreePath path = DbEntityCounterpartAction.buildTreePath((Entity)entity);
        DbEntityCounterpartAction.editor().getProjectTreeView().getSelectionModel().setSelectionPath(path);
        EntityDisplayEvent event = new EntityDisplayEvent((Object)DbEntityCounterpartAction.editor().getProjectTreeView(), (Entity)entity, entity.getDataMap(), (DataChannelDescriptor)this.getProjectController().getProject().getRootNode());
        this.getProjectController().fireDbEntityDisplayEvent(event);
    }
}

