/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.objentity.EntitySyncController;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.util.EntityMergeSupport;

public class ObjEntitySyncAction
extends CayenneAction {
    public static String getActionName() {
        return "Sync ObjEntity with DbEntity";
    }

    public ObjEntitySyncAction(Application application) {
        super(ObjEntitySyncAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-sync.gif";
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    @Override
    public void performAction(ActionEvent e) {
        this.synchObjEntity();
    }

    protected void synchObjEntity() {
        ProjectController mediator = this.getProjectController();
        ObjEntity entity = mediator.getCurrentObjEntity();
        if (entity != null && entity.getDbEntity() != null) {
            EntityMergeSupport merger = new EntitySyncController((CayenneController)Application.getInstance().getFrameController(), entity).createMerger();
            if (merger == null) {
                return;
            }
            if (merger.synchronizeWithDbEntity(entity)) {
                mediator.fireObjEntityEvent(new EntityEvent((Object)this, (Entity)entity, 1));
                mediator.fireObjEntityDisplayEvent(new EntityDisplayEvent((Object)this, (Entity)entity, entity.getDataMap(), (DataChannelDescriptor)mediator.getProject().getRootNode()));
            }
        }
    }
}

