/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.action.ProjectAction;
import org.apache.cayenne.modeler.action.ProjectOpener;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.ProjectLoader;
import org.apache.cayenne.project.upgrade.ProjectUpgrader;
import org.apache.cayenne.project.upgrade.UpgradeHandler;
import org.apache.cayenne.project.upgrade.UpgradeMetaData;
import org.apache.cayenne.project.upgrade.UpgradeType;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.URLResource;
import org.apache.cayenne.swing.control.FileMenuItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenProjectAction
extends ProjectAction {
    private static Log logObj = LogFactory.getLog(OpenProjectAction.class);
    protected ProjectOpener fileChooser = new ProjectOpener();

    public static String getActionName() {
        return "Open Project";
    }

    public OpenProjectAction(Application application) {
        super(OpenProjectAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-open.gif";
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    @Override
    public void performAction(ActionEvent e) {
        if (this.getProjectController() != null && !this.checkSaveOnClose()) {
            return;
        }
        File f = null;
        if (e.getSource() instanceof FileMenuItem) {
            FileMenuItem menu = (FileMenuItem)e.getSource();
            f = menu.getFile();
        } else if (e.getSource() instanceof File) {
            f = (File)e.getSource();
        }
        if (f == null) {
            try {
                f = this.fileChooser.openProjectFile(Application.getFrame());
            }
            catch (Exception ex) {
                logObj.warn((Object)"Error loading project file.", (Throwable)ex);
            }
        }
        if (f != null) {
            if (this.getProjectController() != null && !this.closeProject(false)) {
                return;
            }
            this.openProject(f);
        }
        this.application.getUndoManager().discardAllEdits();
    }

    public void openProject(File file) {
        try {
            if (!file.exists()) {
                JOptionPane.showMessageDialog(Application.getFrame(), "Can't open project - file \"" + file.getPath() + "\" does not exist", "Can't Open Project", 0);
                return;
            }
            CayenneModelerController controller = Application.getInstance().getFrameController();
            controller.addToLastProjListAction(file.getAbsolutePath());
            URL url = file.toURL();
            URLResource rootSource = new URLResource(url);
            ProjectUpgrader upgrader = (ProjectUpgrader)this.getApplication().getInjector().getInstance(ProjectUpgrader.class);
            UpgradeHandler handler = upgrader.getUpgradeHandler((Resource)rootSource);
            UpgradeMetaData md = handler.getUpgradeMetaData();
            if (UpgradeType.DOWNGRADE_NEEDED == md.getUpgradeType()) {
                JOptionPane.showMessageDialog(Application.getFrame(), "Can't open project - it was created using a newer version of the Modeler", "Can't Open Project", 0);
                this.closeProject(false);
            } else if (UpgradeType.INTERMEDIATE_UPGRADE_NEEDED == md.getUpgradeType()) {
                JOptionPane.showMessageDialog(Application.getFrame(), "Can't upgrade project. Open the project in the Modeler v." + md.getIntermediateUpgradeVersion() + " to do an intermediate upgrade before you can upgrade to v." + md.getSupportedVersion(), "Can't Upgrade Project", 0);
                this.closeProject(false);
            } else if (UpgradeType.UPGRADE_NEEDED == md.getUpgradeType()) {
                if (this.processUpgrades(md)) {
                    logObj.info((Object)("Will upgrade project " + url.getPath()));
                    Resource upgraded = handler.performUpgrade();
                    if (upgraded != null) {
                        Project project = this.openProjectResourse(upgraded, controller);
                        this.getProjectController().getFileChangeTracker().pauseWatching();
                        this.getProjectController().getFileChangeTracker().reconfigure();
                        if (!file.getAbsolutePath().equals(project.getConfigurationResource().getURL().getPath())) {
                            controller.changePathInLastProjListAction(file.getAbsolutePath(), project.getConfigurationResource().getURL().getPath());
                        }
                    } else {
                        this.closeProject(false);
                    }
                }
            } else {
                this.openProjectResourse((Resource)rootSource, controller);
            }
        }
        catch (Exception ex) {
            logObj.warn((Object)"Error loading project file.", (Throwable)ex);
            ErrorDebugDialog.guiWarning(ex, "Error loading project");
        }
    }

    private Project openProjectResourse(Resource resource, CayenneModelerController controller) {
        Project project = ((ProjectLoader)this.getApplication().getInjector().getInstance(ProjectLoader.class)).loadProject(resource);
        controller.projectOpenedAction(project);
        return project;
    }

    protected boolean processUpgrades(UpgradeMetaData md) {
        int returnCode = JOptionPane.showConfirmDialog(Application.getFrame(), "Project needs an upgrade to a newer version. Upgrade?", "Upgrade Needed", 0);
        return returnCode != 1;
    }
}

