/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.undo.AbstractUndoableEdit;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.NameChecker;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.CreateAttributeAction;
import org.apache.cayenne.modeler.action.CreateDbEntityAction;
import org.apache.cayenne.modeler.action.CreateEmbeddableAction;
import org.apache.cayenne.modeler.action.CreateObjEntityAction;
import org.apache.cayenne.modeler.action.CreateProcedureAction;
import org.apache.cayenne.modeler.action.CreateProcedureParameterAction;
import org.apache.cayenne.modeler.action.CreateRelationshipAction;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.dialog.query.QueryType;
import org.apache.cayenne.modeler.editor.ObjCallbackMethod;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.undo.PasteCompoundUndoableEdit;
import org.apache.cayenne.modeler.undo.PasteUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneTransferable;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.Query;

public class PasteAction
extends CayenneAction
implements FlavorListener {
    private static final String COPY_PATTERN = "Copy of %s (%d)";

    public static String getActionName() {
        return "Paste";
    }

    public PasteAction(Application application) {
        super(PasteAction.getActionName(), application);
        Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(this);
    }

    @Override
    public String getIconName() {
        return "icon-paste.gif";
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    @Override
    public void performAction(ActionEvent e) {
        try {
            Object content = Toolkit.getDefaultToolkit().getSystemClipboard().getData(CayenneTransferable.CAYENNE_FLAVOR);
            Object currentObject = this.getProjectController().getCurrentObject();
            if (content != null && currentObject != null) {
                AbstractUndoableEdit undoableEdit;
                DataChannelDescriptor domain = (DataChannelDescriptor)this.getProjectController().getProject().getRootNode();
                DataMap map = this.getProjectController().getCurrentDataMap();
                if (content instanceof List) {
                    undoableEdit = new PasteCompoundUndoableEdit();
                    for (Object o : (List)content) {
                        this.paste(currentObject, o);
                        undoableEdit.addEdit(new PasteUndoableEdit(domain, map, currentObject, o));
                    }
                } else {
                    this.paste(currentObject, content);
                    undoableEdit = new PasteUndoableEdit(domain, map, currentObject, content);
                }
                this.application.getUndoManager().addEdit(undoableEdit);
            }
        }
        catch (UnsupportedFlavorException ufe) {
        }
        catch (Exception ex) {
            ErrorDebugDialog.guiException(ex);
        }
    }

    private void paste(Object where, Object content) {
        this.paste(where, content, (DataChannelDescriptor)this.getProjectController().getProject().getRootNode(), this.getProjectController().getCurrentDataMap());
    }

    public void paste(Object where, Object content, DataChannelDescriptor domain, DataMap map) {
        ProjectController mediator = this.getProjectController();
        if (this.isTreeLeaf(where) && this.isTreeLeaf(content)) {
            where = mediator.getCurrentDataMap();
        }
        if ((where instanceof DataChannelDescriptor || where instanceof DataNodeDescriptor) && content instanceof DataMap) {
            String oldName;
            DataMap dataMap = (DataMap)content;
            dataMap.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dataMap, (String)COPY_PATTERN, (Object)domain, (String)dataMap.getName()));
            HashMap<String, String> renamedDbEntities = new HashMap<String, String>();
            HashMap<String, String> renamedObjEntities = new HashMap<String, String>();
            HashMap<String, String> renamedEmbeddables = new HashMap<String, String>();
            for (DbEntity dbEntity : dataMap.getDbEntities()) {
                oldName = dbEntity.getName();
                dbEntity.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dbEntity, (String)COPY_PATTERN, (Object)dataMap, (String)dbEntity.getName()));
                if (oldName.equals(dbEntity.getName())) continue;
                renamedDbEntities.put(oldName, dbEntity.getName());
            }
            for (ObjEntity objEntity : dataMap.getObjEntities()) {
                oldName = objEntity.getName();
                objEntity.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.objEntity, (String)COPY_PATTERN, (Object)dataMap, (String)objEntity.getName()));
                if (oldName.equals(objEntity.getName())) continue;
                renamedObjEntities.put(oldName, objEntity.getName());
            }
            for (Embeddable embeddable : dataMap.getEmbeddables()) {
                oldName = embeddable.getClassName();
                embeddable.setClassName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.embeddable, (String)COPY_PATTERN, (Object)dataMap, (String)embeddable.getClassName()));
                if (oldName.equals(embeddable.getClassName())) continue;
                renamedEmbeddables.put(oldName, embeddable.getClassName());
            }
            for (Procedure procedure : dataMap.getProcedures()) {
                procedure.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.procedure, (String)COPY_PATTERN, (Object)dataMap, (String)procedure.getName()));
            }
            for (Query query : dataMap.getQueries()) {
                ((AbstractQuery)query).setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.query, (String)COPY_PATTERN, (Object)dataMap, (String)query.getName()));
            }
            for (DbEntity dbEntity : dataMap.getDbEntities()) {
                for (DbRelationship rel : dbEntity.getRelationships()) {
                    if (!renamedDbEntities.containsKey(rel.getTargetEntityName())) continue;
                    rel.setTargetEntityName((String)renamedDbEntities.get(rel.getTargetEntityName()));
                }
            }
            for (ObjEntity objEntity : dataMap.getObjEntities()) {
                if (renamedDbEntities.containsKey(objEntity.getDbEntityName())) {
                    objEntity.setDbEntityName((String)renamedDbEntities.get(objEntity.getDbEntityName()));
                }
                if (renamedObjEntities.containsKey(objEntity.getSuperEntityName())) {
                    objEntity.setSuperEntityName((String)renamedDbEntities.get(objEntity.getSuperEntityName()));
                }
                for (DbRelationship rel : objEntity.getRelationships()) {
                    if (!renamedObjEntities.containsKey(rel.getTargetEntityName())) continue;
                    rel.setTargetEntityName((String)renamedObjEntities.get(rel.getTargetEntityName()));
                }
            }
            mediator.addDataMap(this, dataMap);
        } else if (where instanceof DataMap) {
            DataMap dataMap = (DataMap)where;
            this.clearDataMapCache(dataMap);
            if (content instanceof DbEntity) {
                DbEntity dbEntity = (DbEntity)content;
                dbEntity.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dbEntity, (String)COPY_PATTERN, (Object)dataMap, (String)dbEntity.getName()));
                dataMap.addDbEntity(dbEntity);
                CreateDbEntityAction.fireDbEntityEvent(this, mediator, dbEntity);
            } else if (content instanceof ObjEntity) {
                ObjEntity objEntity = (ObjEntity)content;
                objEntity.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.objEntity, (String)COPY_PATTERN, (Object)dataMap, (String)objEntity.getName()));
                dataMap.addObjEntity(objEntity);
                CreateObjEntityAction.fireObjEntityEvent(this, mediator, dataMap, objEntity);
            } else if (content instanceof Embeddable) {
                Embeddable embeddable = (Embeddable)content;
                embeddable.setClassName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.embeddable, (String)COPY_PATTERN, (Object)dataMap, (String)embeddable.getClassName()));
                dataMap.addEmbeddable(embeddable);
                CreateEmbeddableAction.fireEmbeddableEvent(this, mediator, dataMap, embeddable);
            } else if (content instanceof EJBQLQuery) {
                EJBQLQuery query = (EJBQLQuery)content;
                query.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.query, (String)COPY_PATTERN, (Object)dataMap, (String)query.getName()));
                query.setDataMap(dataMap);
                dataMap.addQuery((Query)query);
                QueryType.fireQueryEvent(this, mediator, dataMap, (Query)query);
            } else if (content instanceof Query) {
                AbstractQuery query = (AbstractQuery)content;
                query.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.query, (String)COPY_PATTERN, (Object)dataMap, (String)query.getName()));
                query.setDataMap(dataMap);
                dataMap.addQuery((Query)query);
                QueryType.fireQueryEvent(this, mediator, dataMap, (Query)query);
            } else if (content instanceof Procedure) {
                Procedure procedure = (Procedure)content;
                procedure.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.procedure, (String)COPY_PATTERN, (Object)dataMap, (String)procedure.getName()));
                dataMap.addProcedure(procedure);
                CreateProcedureAction.fireProcedureEvent(this, mediator, dataMap, procedure);
            }
        } else if (where instanceof DbEntity) {
            DbEntity dbEntity = (DbEntity)where;
            if (content instanceof DbAttribute) {
                DbAttribute attr = (DbAttribute)content;
                attr.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dbAttribute, (String)COPY_PATTERN, (Object)dbEntity, (String)attr.getName()));
                dbEntity.addAttribute(attr);
                CreateAttributeAction.fireDbAttributeEvent(this, mediator, mediator.getCurrentDataMap(), dbEntity, attr);
            } else if (content instanceof DbRelationship) {
                DbRelationship rel = (DbRelationship)content;
                rel.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.dbRelationship, (String)COPY_PATTERN, (Object)dbEntity, (String)rel.getName()));
                dbEntity.addRelationship((Relationship)rel);
                CreateRelationshipAction.fireDbRelationshipEvent(this, mediator, dbEntity, rel);
            }
        } else if (where instanceof ObjEntity) {
            ObjEntity objEntity = (ObjEntity)where;
            if (content instanceof ObjAttribute) {
                ObjAttribute attr = (ObjAttribute)content;
                attr.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.objAttribute, (String)COPY_PATTERN, (Object)objEntity, (String)attr.getName()));
                objEntity.addAttribute((Attribute)attr);
                CreateAttributeAction.fireObjAttributeEvent(this, mediator, mediator.getCurrentDataMap(), objEntity, attr);
            } else if (content instanceof ObjRelationship) {
                ObjRelationship rel = (ObjRelationship)content;
                rel.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.objRelationship, (String)COPY_PATTERN, (Object)objEntity, (String)rel.getName()));
                objEntity.addRelationship((Relationship)rel);
                CreateRelationshipAction.fireObjRelationshipEvent(this, mediator, objEntity, rel);
            } else if (content instanceof ObjCallbackMethod) {
                ObjCallbackMethod method = (ObjCallbackMethod)content;
                method.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.objCallbackMethod, (String)COPY_PATTERN, (Object)objEntity, (String)method.getName()));
                objEntity.getCallbackMap().getCallbackDescriptor(mediator.getCurrentCallbackType().getType()).addCallbackMethod(method.getName());
                CallbackMethodEvent ce = new CallbackMethodEvent(this, null, method.getName(), 2);
                this.getProjectController().fireCallbackMethodEvent(ce);
            }
        } else if (where instanceof Embeddable) {
            Embeddable embeddable = (Embeddable)where;
            if (content instanceof EmbeddableAttribute) {
                EmbeddableAttribute attr = (EmbeddableAttribute)content;
                attr.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.embeddableAttribute, (String)COPY_PATTERN, (Object)embeddable, (String)attr.getName()));
                embeddable.addAttribute(attr);
                CreateAttributeAction.fireEmbeddableAttributeEvent(this, mediator, embeddable, attr);
            }
        } else if (where instanceof Procedure) {
            Procedure procedure = (Procedure)where;
            if (content instanceof ProcedureParameter) {
                ProcedureParameter param = (ProcedureParameter)content;
                param.setName(DefaultUniqueNameGenerator.generate((NameChecker)NameCheckers.procedureParameter, (String)COPY_PATTERN, (Object)procedure, (String)param.getName()));
                procedure.addCallParameter(param);
                CreateProcedureParameterAction.fireProcedureParameterEvent(this, mediator, procedure, param);
            }
        }
    }

    private void clearDataMapCache(DataMap dataMap) {
        MappingNamespace ns = dataMap.getNamespace();
        if (ns instanceof EntityResolver) {
            ((EntityResolver)ns).refreshMappingCache();
        }
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        return this.getState();
    }

    public void updateState() {
        this.setEnabled(this.getState());
    }

    private boolean getState() {
        try {
            Object currentObject;
            Object content = Toolkit.getDefaultToolkit().getSystemClipboard().getData(CayenneTransferable.CAYENNE_FLAVOR);
            if (content instanceof List) {
                content = ((List)content).get(0);
            }
            if ((currentObject = this.getProjectController().getCurrentObject()) == null) {
                return false;
            }
            return (currentObject instanceof DataChannelDescriptor || currentObject instanceof DataNodeDescriptor) && content instanceof DataMap || currentObject instanceof DataMap && this.isTreeLeaf(content) || currentObject instanceof DbEntity && (content instanceof DbAttribute || content instanceof DbRelationship || this.isTreeLeaf(content)) || currentObject instanceof ObjEntity && (content instanceof ObjAttribute || content instanceof ObjRelationship || content instanceof ObjCallbackMethod || this.isTreeLeaf(content)) || currentObject instanceof Embeddable && (content instanceof EmbeddableAttribute || this.isTreeLeaf(content)) || currentObject instanceof Procedure && (content instanceof ProcedureParameter || this.isTreeLeaf(content)) || currentObject instanceof Query && this.isTreeLeaf(content);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isTreeLeaf(Object content) {
        return content instanceof DbEntity || content instanceof ObjEntity || content instanceof Embeddable || content instanceof Procedure || content instanceof Query;
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.updateState();
    }
}

