/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.KeyStroke;
import javax.swing.undo.UndoableEdit;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.configuration.event.ProcedureParameterEvent;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EmbeddableAttributeEvent;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.editor.ObjCallbackMethod;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.undo.RemoveAttributeUndoableEdit;
import org.apache.cayenne.modeler.undo.RemoveCallbackMethodUndoableEdit;
import org.apache.cayenne.modeler.undo.RemoveCompoundUndoableEdit;
import org.apache.cayenne.modeler.undo.RemoveRelationshipUndoableEdit;
import org.apache.cayenne.modeler.undo.RemoveUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.query.AbstractQuery;
import org.apache.cayenne.query.Query;

public class RemoveAction
extends CayenneAction {
    public static String getActionName() {
        return "Remove";
    }

    public RemoveAction(Application application) {
        super(RemoveAction.getActionName(), application);
    }

    protected RemoveAction(String actionName, Application application) {
        super(actionName, application);
    }

    @Override
    public String getIconName() {
        return "icon-trash.gif";
    }

    @Override
    public KeyStroke getAcceleratorKey() {
        return KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public ConfirmRemoveDialog getConfirmDeleteDialog(boolean allowAsking) {
        return new ConfirmRemoveDialog(allowAsking);
    }

    @Override
    public void performAction(ActionEvent e) {
        this.performAction(e, true);
    }

    public void performAction(ActionEvent e, boolean allowAsking) {
        ProjectController mediator = this.getProjectController();
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        if (mediator.getCurrentCallbackMethods().length > 0) {
            this.removeMethods(mediator, dialog, this.getProjectController().getCurrentCallbackMethods());
        } else if (mediator.getCurrentObjRelationships().length > 0) {
            this.removeObjRelationships(mediator, dialog, this.getProjectController().getCurrentObjRelationships());
        } else if (mediator.getCurrentDbRelationships().length > 0) {
            this.removeDBRelationships(mediator, dialog, this.getProjectController().getCurrentDbRelationships());
        } else if (mediator.getCurrentObjAttributes().length > 0) {
            this.removeObjAttributes(mediator, dialog, this.getProjectController().getCurrentObjAttributes());
        } else if (mediator.getCurrentEmbAttributes().length > 0) {
            this.removeEmbAttributes(mediator, dialog, this.getProjectController().getCurrentEmbAttributes());
        } else if (mediator.getCurrentDbAttributes().length > 0) {
            this.removeDbAttributes(mediator, dialog, this.getProjectController().getCurrentDbAttributes());
        } else if (mediator.getCurrentProcedureParameters().length > 0) {
            this.removeProcedureParameters(mediator.getCurrentProcedure(), mediator.getCurrentProcedureParameters());
        } else if (mediator.getCurrentObjEntity() != null) {
            if (dialog.shouldDelete("ObjEntity", mediator.getCurrentObjEntity().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentObjEntity()));
                this.removeObjEntity(mediator.getCurrentDataMap(), mediator.getCurrentObjEntity());
            }
        } else if (mediator.getCurrentDbEntity() != null) {
            if (dialog.shouldDelete("DbEntity", mediator.getCurrentDbEntity().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentDbEntity()));
                this.removeDbEntity(mediator.getCurrentDataMap(), mediator.getCurrentDbEntity());
            }
        } else if (mediator.getCurrentQuery() != null) {
            if (dialog.shouldDelete("query", mediator.getCurrentQuery().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentQuery()));
                this.removeQuery(mediator.getCurrentDataMap(), mediator.getCurrentQuery());
            }
        } else if (mediator.getCurrentProcedure() != null) {
            if (dialog.shouldDelete("procedure", mediator.getCurrentProcedure().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentProcedure()));
                this.removeProcedure(mediator.getCurrentDataMap(), mediator.getCurrentProcedure());
            }
        } else if (mediator.getCurrentEmbeddable() != null) {
            if (dialog.shouldDelete("embeddable", mediator.getCurrentEmbeddable().getClassName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(mediator.getCurrentDataMap(), mediator.getCurrentEmbeddable()));
                this.removeEmbeddable(mediator.getCurrentDataMap(), mediator.getCurrentEmbeddable());
            }
        } else if (mediator.getCurrentDataMap() != null) {
            if (dialog.shouldDelete("data map", mediator.getCurrentDataMap().getName())) {
                if (mediator.getCurrentDataNode() != null) {
                    this.application.getUndoManager().addEdit(new RemoveUndoableEdit(this.application, mediator.getCurrentDataNode(), mediator.getCurrentDataMap()));
                    this.removeDataMapFromDataNode(mediator.getCurrentDataNode(), mediator.getCurrentDataMap());
                } else {
                    this.application.getUndoManager().addEdit(new RemoveUndoableEdit(this.application, mediator.getCurrentDataMap()));
                    this.removeDataMap(mediator.getCurrentDataMap());
                }
            }
        } else if (mediator.getCurrentDataNode() != null) {
            if (dialog.shouldDelete("data node", mediator.getCurrentDataNode().getName())) {
                this.application.getUndoManager().addEdit(new RemoveUndoableEdit(this.application, mediator.getCurrentDataNode()));
                this.removeDataNode(mediator.getCurrentDataNode());
            }
        } else if (mediator.getCurrentPaths() != null && dialog.shouldDelete("selected objects")) {
            Object[] paths = mediator.getCurrentPaths();
            Object parentPath = mediator.getCurrentParentPath();
            RemoveCompoundUndoableEdit compoundEdit = new RemoveCompoundUndoableEdit();
            for (Object path : paths) {
                compoundEdit.addEdit(this.removeLastPathComponent(path, parentPath));
            }
            compoundEdit.end();
            this.application.getUndoManager().addEdit(compoundEdit);
        }
    }

    private void removeProcedureParameters(Procedure procedure, ProcedureParameter[] parameters) {
        ProjectController mediator = this.getProjectController();
        for (ProcedureParameter parameter : parameters) {
            procedure.removeCallParameter(parameter.getName());
            ProcedureParameterEvent e = new ProcedureParameterEvent((Object)Application.getFrame(), parameter, 3);
            mediator.fireProcedureParameterEvent(e);
        }
    }

    private void removeEmbAttributes(ProjectController mediator, ConfirmRemoveDialog dialog, EmbeddableAttribute[] embAttrs) {
        if (embAttrs != null && embAttrs.length > 0 && (embAttrs.length == 1 && dialog.shouldDelete("DbAttribute", embAttrs[0].getName()) || embAttrs.length > 1 && dialog.shouldDelete("selected DbAttributes"))) {
            Embeddable embeddable = mediator.getCurrentEmbeddable();
            this.application.getUndoManager().addEdit(new RemoveAttributeUndoableEdit(embeddable, embAttrs));
            for (EmbeddableAttribute attrib : embAttrs) {
                embeddable.removeAttribute(attrib.getName());
                EmbeddableAttributeEvent e = new EmbeddableAttributeEvent((Object)Application.getFrame(), attrib, embeddable, 3);
                mediator.fireEmbeddableAttributeEvent(e);
            }
            ProjectUtil.cleanObjMappings(mediator.getCurrentDataMap());
        }
    }

    private void removeObjAttributes(ProjectController mediator, ConfirmRemoveDialog dialog, ObjAttribute[] objAttrs) {
        if (objAttrs != null && objAttrs.length > 0 && (objAttrs.length == 1 && dialog.shouldDelete("DbAttribute", objAttrs[0].getName()) || objAttrs.length > 1 && dialog.shouldDelete("selected DbAttributes"))) {
            ObjEntity entity = mediator.getCurrentObjEntity();
            this.application.getUndoManager().addEdit(new RemoveAttributeUndoableEdit((DataChannelDescriptor)mediator.getProject().getRootNode(), mediator.getCurrentDataMap(), entity, objAttrs));
            for (ObjAttribute attrib : objAttrs) {
                entity.removeAttribute(attrib.getName());
                AttributeEvent e = new AttributeEvent((Object)Application.getFrame(), (Attribute)attrib, (Entity)entity, 3);
                mediator.fireObjAttributeEvent(e);
            }
            ProjectUtil.cleanObjMappings(mediator.getCurrentDataMap());
        }
    }

    private void removeDbAttributes(ProjectController mediator, ConfirmRemoveDialog dialog, DbAttribute[] dbAttrs) {
        if (dbAttrs != null && dbAttrs.length > 0 && (dbAttrs.length == 1 && dialog.shouldDelete("DbAttribute", dbAttrs[0].getName()) || dbAttrs.length > 1 && dialog.shouldDelete("selected DbAttributes"))) {
            DbEntity entity = mediator.getCurrentDbEntity();
            this.application.getUndoManager().addEdit(new RemoveAttributeUndoableEdit((DataChannelDescriptor)mediator.getProject().getRootNode(), mediator.getCurrentDataMap(), entity, dbAttrs));
            for (DbAttribute attrib : dbAttrs) {
                entity.removeAttribute(attrib.getName());
                AttributeEvent e = new AttributeEvent((Object)Application.getFrame(), (Attribute)attrib, (Entity)entity, 3);
                mediator.fireDbAttributeEvent(e);
            }
            ProjectUtil.cleanObjMappings(mediator.getCurrentDataMap());
        }
    }

    private void removeDBRelationships(ProjectController mediator, ConfirmRemoveDialog dialog, DbRelationship[] dbRels) {
        if (dbRels != null && dbRels.length > 0 && (dbRels.length == 1 && dialog.shouldDelete("DbRelationship", dbRels[0].getName()) || dbRels.length > 1 && dialog.shouldDelete("selected DbRelationships"))) {
            DbEntity entity = mediator.getCurrentDbEntity();
            for (DbRelationship rel : dbRels) {
                entity.removeRelationship(rel.getName());
                RelationshipEvent e = new RelationshipEvent((Object)Application.getFrame(), (Relationship)rel, (Entity)entity, 3);
                mediator.fireDbRelationshipEvent(e);
            }
            ProjectUtil.cleanObjMappings(mediator.getCurrentDataMap());
            Application.getInstance().getUndoManager().addEdit(new RemoveRelationshipUndoableEdit(entity, dbRels));
        }
    }

    private void removeObjRelationships(ProjectController mediator, ConfirmRemoveDialog dialog, ObjRelationship[] rels) {
        if (rels.length == 1 && dialog.shouldDelete("ObjRelationship", rels[0].getName()) || rels.length > 1 && dialog.shouldDelete("selected ObjRelationships")) {
            ObjEntity entity = mediator.getCurrentObjEntity();
            for (ObjRelationship rel : rels) {
                entity.removeRelationship(rel.getName());
                RelationshipEvent e = new RelationshipEvent((Object)Application.getFrame(), (Relationship)rel, (Entity)entity, 3);
                mediator.fireObjRelationshipEvent(e);
            }
            Application.getInstance().getUndoManager().addEdit(new RemoveRelationshipUndoableEdit(entity, rels));
        }
    }

    private void removeMethods(ProjectController mediator, ConfirmRemoveDialog dialog, ObjCallbackMethod[] methods) {
        CallbackMap callbackMap = mediator.getCurrentObjEntity().getCallbackMap();
        CallbackType callbackType = mediator.getCurrentCallbackType();
        if (methods.length == 1 && dialog.shouldDelete("callback method", methods[0].getName()) || methods.length > 1 && dialog.shouldDelete("selected callback methods")) {
            for (ObjCallbackMethod callbackMethod : methods) {
                callbackMap.getCallbackDescriptor(callbackType.getType()).removeCallbackMethod(callbackMethod.getName());
                CallbackMethodEvent ce = new CallbackMethodEvent(this, null, callbackMethod.getName(), 3);
                mediator.fireCallbackMethodEvent(ce);
            }
            Application.getInstance().getUndoManager().addEdit(new RemoveCallbackMethodUndoableEdit(callbackType, methods));
        }
    }

    public void removeDataMap(DataMap map) {
        ProjectController mediator = this.getProjectController();
        DataChannelDescriptor domain = (DataChannelDescriptor)mediator.getProject().getRootNode();
        DataMapEvent e = new DataMapEvent((Object)Application.getFrame(), map, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        domain.getDataMaps().remove(map);
        if (map.getConfigurationSource() != null) {
            URL mapURL = map.getConfigurationSource().getURL();
            this.getCurrentProject().getUnusedResources().add(mapURL);
        }
        for (DataNodeDescriptor node : domain.getNodeDescriptors()) {
            if (!node.getDataMapNames().contains(map.getName())) continue;
            this.removeDataMapFromDataNode(node, map);
        }
        mediator.fireDataMapEvent(e);
    }

    public void removeDataNode(DataNodeDescriptor node) {
        ProjectController mediator = this.getProjectController();
        DataChannelDescriptor domain = (DataChannelDescriptor)mediator.getProject().getRootNode();
        DataNodeEvent e = new DataNodeEvent((Object)Application.getFrame(), node, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        domain.getNodeDescriptors().remove(node);
        mediator.fireDataNodeEvent(e);
    }

    public void removeDbEntity(DataMap map, DbEntity ent) {
        ProjectController mediator = this.getProjectController();
        EntityEvent e = new EntityEvent((Object)Application.getFrame(), (Entity)ent, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        map.removeDbEntity(ent.getName(), true);
        mediator.fireDbEntityEvent(e);
    }

    public void removeQuery(DataMap map, Query query) {
        ProjectController mediator = this.getProjectController();
        QueryEvent e = new QueryEvent((Object)Application.getFrame(), query, 3, map);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        map.removeQuery(query.getName());
        mediator.fireQueryEvent(e);
    }

    public void removeProcedure(DataMap map, Procedure procedure) {
        ProjectController mediator = this.getProjectController();
        ProcedureEvent e = new ProcedureEvent((Object)Application.getFrame(), procedure, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        map.removeProcedure(procedure.getName());
        mediator.fireProcedureEvent(e);
    }

    public void removeObjEntity(DataMap map, ObjEntity entity) {
        ProjectController mediator = this.getProjectController();
        EntityEvent e = new EntityEvent((Object)Application.getFrame(), (Entity)entity, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        map.removeObjEntity(entity.getName(), true);
        mediator.fireObjEntityEvent(e);
        for (Query query : new ArrayList(map.getQueries())) {
            AbstractQuery next;
            Object root;
            if (!(query instanceof AbstractQuery) || (root = (next = (AbstractQuery)query).getRoot()) != entity && (!(root instanceof String) || !root.toString().equals(entity.getName()))) continue;
            this.removeQuery(map, (Query)next);
        }
    }

    public void removeEmbeddable(DataMap map, Embeddable embeddable) {
        ProjectController mediator = this.getProjectController();
        EmbeddableEvent e = new EmbeddableEvent((Object)Application.getFrame(), embeddable, 3);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        map.removeEmbeddable(embeddable.getClassName());
        mediator.fireEmbeddableEvent(e, map);
    }

    public void removeDataMapFromDataNode(DataNodeDescriptor node, DataMap map) {
        ProjectController mediator = this.getProjectController();
        DataNodeEvent e = new DataNodeEvent(Application.getFrame(), node);
        e.setDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        node.getDataMapNames().remove(map.getName());
        mediator.fireDataNodeEvent(e);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        if (object instanceof DataChannelDescriptor) {
            return true;
        }
        if (object instanceof DataMap) {
            return true;
        }
        if (object instanceof DataNodeDescriptor) {
            return true;
        }
        if (object instanceof Entity) {
            return true;
        }
        if (object instanceof Attribute) {
            return true;
        }
        if (object instanceof Relationship) {
            return true;
        }
        if (object instanceof Procedure) {
            return true;
        }
        if (object instanceof ProcedureParameter) {
            return true;
        }
        if (object instanceof Embeddable) {
            return true;
        }
        return object instanceof EmbeddableAttribute;
    }

    private UndoableEdit removeLastPathComponent(Object object, Object parentObject) {
        RemoveUndoableEdit undo = null;
        if (object instanceof DataMap) {
            if (parentObject != null && parentObject instanceof DataNodeDescriptor) {
                undo = new RemoveUndoableEdit(this.application, (DataNodeDescriptor)parentObject, (DataMap)object);
                this.removeDataMapFromDataNode((DataNodeDescriptor)parentObject, (DataMap)object);
            } else {
                undo = new RemoveUndoableEdit(this.application, (DataMap)object);
                this.removeDataMap((DataMap)object);
            }
        } else if (object instanceof DataNodeDescriptor) {
            undo = new RemoveUndoableEdit(this.application, (DataNodeDescriptor)object);
            this.removeDataNode((DataNodeDescriptor)object);
        } else if (object instanceof DbEntity) {
            undo = new RemoveUndoableEdit(((DbEntity)object).getDataMap(), (DbEntity)object);
            this.removeDbEntity(((DbEntity)object).getDataMap(), (DbEntity)object);
        } else if (object instanceof ObjEntity) {
            undo = new RemoveUndoableEdit(((ObjEntity)object).getDataMap(), (ObjEntity)object);
            this.removeObjEntity(((ObjEntity)object).getDataMap(), (ObjEntity)object);
        } else if (object instanceof Query) {
            undo = new RemoveUndoableEdit(((Query)object).getDataMap(), (Query)object);
            this.removeQuery(((Query)object).getDataMap(), (Query)object);
        } else if (object instanceof Procedure) {
            undo = new RemoveUndoableEdit(((Procedure)object).getDataMap(), (Procedure)object);
            this.removeProcedure(((Procedure)object).getDataMap(), (Procedure)object);
        } else if (object instanceof Embeddable) {
            undo = new RemoveUndoableEdit(((Embeddable)object).getDataMap(), (Embeddable)object);
            this.removeEmbeddable(((Embeddable)object).getDataMap(), (Embeddable)object);
        }
        return undo;
    }
}

