/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.map.CallbackMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.RemoveAction;
import org.apache.cayenne.modeler.dialog.ConfirmRemoveDialog;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.editor.ObjCallbackMethod;
import org.apache.cayenne.modeler.event.CallbackMethodEvent;
import org.apache.cayenne.modeler.undo.RemoveCallbackMethodUndoableEdit;

public class RemoveCallbackMethodAction
extends RemoveAction {
    public static final String ACTION_NAME = "Remove Callback Method";
    private static final String ACTION_NAME_MULTIPLE = "Remove Callback Methods";

    public RemoveCallbackMethodAction(Application application) {
        super(RemoveCallbackMethodAction.getActionName(), application);
    }

    @Override
    public String getIconName() {
        return "icon-trash.gif";
    }

    @Override
    public void performAction(ActionEvent e, boolean allowAsking) {
        ConfirmRemoveDialog dialog = this.getConfirmDeleteDialog(allowAsking);
        ObjCallbackMethod[] methods = this.getProjectController().getCurrentCallbackMethods();
        if (methods.length == 1 && dialog.shouldDelete("callback method", methods[0].getName()) || methods.length > 1 && dialog.shouldDelete("selected callback methods")) {
            this.removeCallbackMethods(e);
        }
    }

    private void removeCallbackMethods(ActionEvent actionEvent) {
        ObjCallbackMethod[] callbackMethods;
        ProjectController mediator = this.getProjectController();
        CallbackType callbackType = mediator.getCurrentCallbackType();
        for (ObjCallbackMethod callbackMethod : callbackMethods = mediator.getCurrentCallbackMethods()) {
            this.removeCallbackMethod(callbackType, callbackMethod.getName());
        }
        Application.getInstance().getUndoManager().addEdit(new RemoveCallbackMethodUndoableEdit(callbackType, callbackMethods));
    }

    public void removeCallbackMethod(CallbackType callbackType, String method) {
        ProjectController mediator = this.getProjectController();
        this.getCallbackMap().getCallbackDescriptor(callbackType.getType()).removeCallbackMethod(method);
        CallbackMethodEvent e = new CallbackMethodEvent(this, null, method, 3);
        mediator.fireCallbackMethodEvent(e);
    }

    public static String getActionName() {
        return ACTION_NAME;
    }

    public CallbackMap getCallbackMap() {
        return this.getProjectController().getCurrentObjEntity().getCallbackMap();
    }

    public String getActionName(boolean multiple) {
        return multiple ? ACTION_NAME_MULTIPLE : ACTION_NAME;
    }
}

