/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.dialog.WarningDialog;
import org.apache.cayenne.modeler.util.CayenneDialog;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.util.LocalizedStringsHandler;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorDebugDialog
extends CayenneDialog
implements ActionListener {
    private static Log logObj = LogFactory.getLog(ErrorDebugDialog.class);
    private static ErrorDebugDialog instance;
    protected JButton close;
    protected JButton showHide;
    protected JTextArea exText = new JTextArea();
    protected JPanel exPanel;
    protected Throwable throwable;
    protected boolean detailed;

    public static void guiException(Throwable th) {
        if (th != null) {
            logObj.error((Object)"CayenneModeler Error", th);
        }
        ErrorDebugDialog dialog = new ErrorDebugDialog(Application.getFrame(), "CayenneModeler Error", th, true, false);
        ErrorDebugDialog.showDialog(dialog);
    }

    public static void guiWarning(Throwable th, String message) {
        if (th != null) {
            logObj.warn((Object)"CayenneModeler Warning", th);
        }
        WarningDialog dialog = new WarningDialog(Application.getFrame(), message, th, false, false);
        ErrorDebugDialog.showDialog(dialog);
    }

    private static void showDialog(ErrorDebugDialog dialog) {
        if (instance != null) {
            instance.dispose();
        }
        instance = dialog;
        dialog.setVisible(true);
    }

    protected ErrorDebugDialog(CayenneModelerFrame owner, String title, Throwable throwable, boolean detailed) throws HeadlessException {
        this(owner, title, throwable, detailed, true);
    }

    protected ErrorDebugDialog(CayenneModelerFrame owner, String title, Throwable throwable, boolean detailed, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.setThrowable(Util.unwindException((Throwable)throwable));
        this.setDetailed(detailed);
        this.init();
    }

    protected void init() {
        JButton[] jButtonArray;
        this.setResizable(false);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JEditorPane infoText = new JEditorPane("text/html", this.infoHTML());
        infoText.setBackground(pane.getBackground());
        infoText.setEditable(false);
        infoText.addHyperlinkListener(this);
        JPanel infoPanel = new JPanel();
        infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        infoPanel.add(infoText);
        pane.add((Component)infoPanel, "North");
        if (this.throwable != null) {
            this.exText.setEditable(false);
            this.exText.setLineWrap(true);
            this.exText.setWrapStyleWord(true);
            this.exText.setRows(16);
            this.exText.setColumns(40);
            JScrollPane exScroll = new JScrollPane(this.exText, 20, 30);
            this.exPanel = new JPanel();
            this.exPanel.setLayout(new BorderLayout());
            this.exPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.exPanel.add((Component)exScroll, "Center");
            this.showHide = new JButton("");
            this.showHide.addActionListener(this);
            if (this.isDetailed()) {
                this.showDetails();
            } else {
                this.hideDetails();
            }
        }
        this.close = new JButton("Close");
        this.close.addActionListener(this);
        if (this.showHide != null) {
            JButton[] jButtonArray2 = new JButton[2];
            jButtonArray2[0] = this.showHide;
            jButtonArray = jButtonArray2;
            jButtonArray2[1] = this.close;
        } else {
            JButton[] jButtonArray3 = new JButton[1];
            jButtonArray = jButtonArray3;
            jButtonArray3[0] = this.close;
        }
        JButton[] buttons = jButtonArray;
        pane.add((Component)PanelFactory.createButtonPanel(buttons), "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                instance = null;
            }
        });
        this.pack();
        this.centerWindow();
    }

    protected String infoHTML() {
        String bugreportURL = ModelerUtil.getProperty("cayenne.bugreport.url");
        return "<b><font face='Arial,Helvetica' size='+1' color='red'>" + this.getTitle() + "</font></b><br>" + "<font face='Arial,Helvetica' size='-1'>Please copy the message below and " + "report this error by going to <br>" + "<a href='" + bugreportURL + "'>" + bugreportURL + "</a></font>";
    }

    protected void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        String text = null;
        if (throwable != null) {
            StringWriter str = new StringWriter();
            PrintWriter out = new PrintWriter(str);
            String version = LocalizedStringsHandler.getString((String)"cayenne.version");
            version = version != null ? version : "(unknown)";
            String buildDate = LocalizedStringsHandler.getString((String)"cayenne.build.date");
            buildDate = buildDate != null ? buildDate : "(unknown)";
            out.println("CayenneModeler Info");
            out.println("Version: " + version);
            out.println("Build Date: " + buildDate);
            out.println("Exception: ");
            out.println("=================================");
            this.buildStackTrace(out, throwable);
            try {
                out.close();
                str.close();
            }
            catch (IOException ioex) {
                // empty catch block
            }
            text = str.getBuffer().toString();
        }
        this.exText.setText(text);
    }

    protected void buildStackTrace(PrintWriter out, Throwable th) {
        if (th == null) {
            return;
        }
        th.printStackTrace(out);
        Throwable cause = th.getCause();
        if (cause != null) {
            out.println("Caused by:");
            this.buildStackTrace(out, cause);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close) {
            this.dispose();
        } else if (e.getSource() == this.showHide) {
            if (this.isDetailed()) {
                this.hideDetails();
            } else {
                this.showDetails();
            }
            this.pack();
            this.centerWindow();
        }
    }

    protected void hideDetails() {
        this.getContentPane().remove(this.exPanel);
        this.showHide.setText("Show Details");
        this.setDetailed(false);
    }

    protected void showDetails() {
        this.getContentPane().add((Component)this.exPanel, "Center");
        this.showHide.setText("Hide Details");
        this.setDetailed(true);
    }

    public boolean isDetailed() {
        return this.detailed;
    }

    public void setDetailed(boolean detailed) {
        this.detailed = detailed;
    }
}

